/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.hibernate;

import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.usertype.UserType;

public final class HibernateField {
    public static final boolean NULLABLE_COLUMN = true;
    public static final boolean NOT_NULLABLE_COLUMN = false;
    private final List<Type> types;
    private final List<String> propertyNames;
    private final List<String> columnNames;
    private final Class<?> referencedClass;
    private final boolean nullable;

    public HibernateField(Type type, String propertyName, String[] columnNames, Class<?> referencedClass, boolean nullable) {
        this(Collections.singletonList(type), Collections.singletonList(propertyName), columnNames, referencedClass, nullable);
    }

    public HibernateField(List<Type> types, List<String> propertyNames, String[] columnNames, Class<?> referencedClass, boolean nullable) {
        this.types = types;
        this.propertyNames = propertyNames;
        this.columnNames = Collections.unmodifiableList(Arrays.asList(columnNames));
        this.referencedClass = referencedClass;
        this.nullable = nullable;
    }

    public String getPropertyName() {
        if (this.propertyNames.size() != 1) {
            throw new IllegalStateException("Hibernate Field has more than one property name or the property name has not been initialised.");
        }
        return this.propertyNames.get(0);
    }

    public String getPropertyName(String columnName) {
        if (!this.columnNames.contains(columnName)) {
            throw new IllegalArgumentException("Property name for given column name does not exist");
        }
        return this.propertyNames.get(this.columnNames.indexOf(columnName));
    }

    public Type getIdPropertyType(String columnName) {
        return this.types.get(this.columnNames.indexOf(columnName));
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Class<?> getReferencedClass() {
        return this.referencedClass;
    }

    public String getSingleColumnName() {
        if (this.columnNames.size() != 1) {
            throw new IllegalArgumentException("Hibernate field " + String.valueOf(this.types.get(0)) + " should have only one column, but it has " + this.columnNames.size());
        }
        return this.columnNames.get(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HibernateField that = (HibernateField)o;
        return Objects.equals(this.types, that.types) && Objects.equals(this.propertyNames, that.propertyNames) && Objects.equals(this.columnNames, that.columnNames) && Objects.equals(this.referencedClass, that.referencedClass);
    }

    public int hashCode() {
        return Objects.hash(this.types, this.propertyNames, this.columnNames, this.referencedClass);
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public Type getType() {
        if (this.types.isEmpty()) {
            throw new IllegalStateException("Hibernate field should have only one column, but it has " + this.columnNames.size());
        }
        if (this.types.size() != 1) {
            throw new IllegalStateException("Hibernate field " + String.valueOf(this.types.get(0)) + " should have only one column, but it has " + this.columnNames.size());
        }
        return this.types.get(0);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    public String toString() {
        return "HibernateField{types=" + String.valueOf(this.types) + ", propertyNames=" + String.valueOf(this.propertyNames) + ", columnNames=" + String.valueOf(this.columnNames) + ", referencedClass=" + String.valueOf(this.referencedClass) + "}";
    }

    public static interface Type {
        public static @Nullable Type wrap(@Nullable org.hibernate.type.Type type) {
            return type == null ? null : new HibernateType(type);
        }

        public static Type manyToOne(SessionFactoryImplementor sessionFactory, Class<?> entityClass) {
            return Type.wrap((org.hibernate.type.Type)sessionFactory.getTypeResolver().getTypeFactory().manyToOne(entityClass.getName()));
        }

        default public boolean isCollectionType() {
            return false;
        }

        default public boolean isAssociationType() {
            return false;
        }

        default public boolean matches(org.hibernate.type.Type type) {
            return false;
        }

        public Class getReturnedClass();

        default public String getAssociatedEntityName() {
            throw new UnsupportedOperationException();
        }

        default public int getSqlType() {
            throw new UnsupportedOperationException();
        }

        default public String[] getPropertyNames() {
            throw new UnsupportedOperationException();
        }

        default public UserType getUserType() {
            throw new UnsupportedOperationException();
        }

        default public boolean isCustomType() {
            return false;
        }

        default public boolean isComponentType() {
            return false;
        }
    }
}

