/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.hibernate;

import com.atlassian.confluence.core.NotExportable;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfoFactory;
import com.atlassian.confluence.pages.AttachmentData;
import com.atlassian.confluence.security.denormalisedpermissions.impl.space.domain.DenormalisedSpacePermission;
import com.atlassian.confluence.security.persistence.dao.hibernate.legacy.HibernateKey;
import com.atlassian.crowd.directory.DirectorySynchronisationStatusImpl;
import com.atlassian.crowd.directory.DirectorySynchronisationToken;
import jakarta.persistence.metamodel.EntityType;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hibernate.SessionFactory;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;

public class HibernateMetadataHelper {
    private final ExportableEntityInfoFactory exportableEntityInfoFactory;
    private final SessionFactory sessionFactory;
    private final boolean realReferenceClassesUsedInExport;
    private final ConcurrentHashMap<Object, Class<?>> allPersistedContentEntities = new ConcurrentHashMap();
    private static final Map<String, Class<?>> classByClassName = new ConcurrentHashMap();
    private final Map<Class<?>, AbstractEntityPersister> persistersByClass = new ConcurrentHashMap();
    private final Map<EntityType<?>, ExportableEntityInfo> allExportableEntitiesByType = new HashMap();
    private final Map<Class<?>, ExportableEntityInfo> allExportableEntitiesByClass = new HashMap();
    private final Map<Class<?>, ExportableEntityInfo> additionalExportableEntitiesByClass = new HashMap();
    private final Collection<ExportableEntityInfo> allSpaceImportableEntities = new HashSet<ExportableEntityInfo>();
    private final Collection<ExportableEntityInfo> allEntitiesForSpaceDeletion = new HashSet<ExportableEntityInfo>();
    private final Collection<ExportableEntityInfo> allSiteImportableEntities = new HashSet<ExportableEntityInfo>();
    private final Set<Class<?>> nonExportableEntities = Set.of(HibernateKey.class, DirectorySynchronisationStatusImpl.class, DirectorySynchronisationToken.class, AttachmentData.class);

    public HibernateMetadataHelper(ExportableEntityInfoFactory exportableEntityInfoFactory, SessionFactory sessionFactory, boolean realReferenceClassesUsedInExport) {
        this.exportableEntityInfoFactory = exportableEntityInfoFactory;
        this.sessionFactory = sessionFactory;
        this.realReferenceClassesUsedInExport = realReferenceClassesUsedInExport;
        this.initEntities();
    }

    public Class<?> getRealContentEntityObjectSubclass(Object id, Class<?> clazz) {
        if (this.realReferenceClassesUsedInExport) {
            return this.allPersistedContentEntities.get(id);
        }
        return clazz;
    }

    public void registerContentEntityObject(Object id, Class<?> clazz) {
        if (this.realReferenceClassesUsedInExport) {
            this.allPersistedContentEntities.put(id, clazz);
        }
    }

    private void initEntities() {
        Set<EntityType<?>> entityTypes = this.excludeDenormalisedEntities(this.sessionFactory.getMetamodel().getEntities());
        entityTypes.forEach(entityType -> {
            boolean exportable = this.isExportable((EntityType<?>)entityType);
            AbstractEntityPersister entityPersister = this.getPersister(entityType.getJavaType());
            ExportableEntityInfo exportableEntityInfo = this.exportableEntityInfoFactory.createExportableEntityInfo(entityPersister);
            if (this.isSuitableForSpaceRestore(exportableEntityInfo.getEntityClass())) {
                if (exportable) {
                    this.allSpaceImportableEntities.add(exportableEntityInfo);
                }
                this.allEntitiesForSpaceDeletion.add(exportableEntityInfo);
            }
            if (exportable) {
                this.allSiteImportableEntities.add(exportableEntityInfo);
                this.allExportableEntitiesByType.put((EntityType<?>)entityType, exportableEntityInfo);
                this.allExportableEntitiesByClass.put(entityType.getJavaType(), exportableEntityInfo);
            }
        });
        this.initAdditionalExportableEntities();
    }

    private Set<EntityType<?>> excludeDenormalisedEntities(Set<EntityType<?>> entities) {
        return entities.stream().filter(entityType -> !entityType.getJavaType().getPackage().equals(DenormalisedSpacePermission.class.getPackage())).collect(Collectors.toSet());
    }

    private boolean isExportable(EntityType<?> entityType) {
        return !NotExportable.class.isAssignableFrom(entityType.getJavaType()) && !this.nonExportableEntities.contains(entityType.getJavaType());
    }

    private void initAdditionalExportableEntities() {
        this.addAdditionalExportableEntity(this.exportableEntityInfoFactory.createAncestorsEntityInfo());
        this.addAdditionalExportableEntity(this.exportableEntityInfoFactory.createApplicationAttributeEntityInfo());
        this.addAdditionalExportableEntity(this.exportableEntityInfoFactory.createDirectoryAttributeEntityInfo());
        this.addAdditionalExportableEntity(this.exportableEntityInfoFactory.createDirectoryOperationEntityInfo());
        this.addAdditionalExportableEntity(this.exportableEntityInfoFactory.createDirectoryMappingOperationEntityInfo());
        this.allExportableEntitiesByClass.putAll(this.additionalExportableEntitiesByClass);
    }

    private void addAdditionalExportableEntity(ExportableEntityInfo additionalExportableEntity) {
        this.additionalExportableEntitiesByClass.put(additionalExportableEntity.getEntityClass(), additionalExportableEntity);
    }

    private boolean isSuitableForSpaceRestore(Class<?> entityClass) {
        if (Modifier.isAbstract(entityClass.getModifiers())) {
            return false;
        }
        if (entityClass.getPackage().getName().startsWith("com.atlassian.crowd")) {
            return false;
        }
        if (entityClass.getPackage().getName().startsWith("com.atlassian.confluence.impl.audit")) {
            return false;
        }
        return !entityClass.getPackage().getName().startsWith("com.atlassian.confluence.internal.diagnostics");
    }

    public Map<EntityType<?>, ExportableEntityInfo> getAllExportableEntities() {
        return this.allExportableEntitiesByType;
    }

    public static Class<?> getClassByClassName(String entityClassName) {
        return classByClassName.computeIfAbsent(entityClassName, k -> {
            try {
                return Class.forName(entityClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to find class for " + entityClassName, e);
            }
        });
    }

    public AbstractEntityPersister getPersister(Class<?> clazz) {
        return this.persistersByClass.computeIfAbsent(clazz, k -> (AbstractEntityPersister)((MetamodelImplementor)this.sessionFactory.getMetamodel()).entityPersister(clazz));
    }

    public Map<Class<?>, ExportableEntityInfo> getAllExportableEntitiesByClass() {
        return this.allExportableEntitiesByClass;
    }

    public String getIdPropertyName(Class<?> clazz) {
        return this.getPersister(clazz).getIdentifierPropertyName();
    }

    public static String removeQuotes(String name) {
        return name.replace("\"", "").replace("'", "").replace("[", "").replace("]", "").replace("`", "");
    }

    public ExportableEntityInfo getEntityInfoByClass(Class<?> clazz) {
        return this.allExportableEntitiesByClass.get(clazz);
    }

    public ExportableEntityInfo getEntityInfoByClassName(String className) {
        for (Map.Entry<Class<?>, ExportableEntityInfo> allExportableEntitiesByClassEntry : this.allExportableEntitiesByClass.entrySet()) {
            if (!allExportableEntitiesByClassEntry.getKey().getName().equals(className)) continue;
            return allExportableEntitiesByClassEntry.getValue();
        }
        return null;
    }

    public Map<Class<?>, ExportableEntityInfo> getAdditionalExportableEntitiesByClass() {
        return this.additionalExportableEntitiesByClass;
    }

    public Collection<ExportableEntityInfo> getAllSpaceImportableEntities() {
        return this.allSpaceImportableEntities;
    }

    public Collection<ExportableEntityInfo> getAllSiteImportableEntities() {
        return this.allSiteImportableEntities;
    }

    public Collection<ExportableEntityInfo> getAllEntitiesForSpaceDeletion() {
        return this.allEntitiesForSpaceDeletion;
    }
}

