/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.hibernate;

import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateField;
import java.util.Objects;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;

final class HibernateType
implements HibernateField.Type {
    private final Type type;

    HibernateType(Type type) {
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public boolean isCollectionType() {
        return this.type.isCollectionType();
    }

    @Override
    public boolean isAssociationType() {
        return this.type.isAssociationType();
    }

    @Override
    public boolean matches(Type type) {
        return Objects.equals(type, this.type);
    }

    @Override
    public Class getReturnedClass() {
        return this.type.getReturnedClass();
    }

    @Override
    public String getAssociatedEntityName() {
        return ((EntityType)this.type).getAssociatedEntityName();
    }

    @Override
    public int getSqlType() {
        int[] sqlTypes = ((CustomType)this.type).getUserType().sqlTypes();
        if (sqlTypes.length != 1) {
            throw new IllegalStateException("Composite columns with enums are not supported at the moment.");
        }
        return sqlTypes[0];
    }

    @Override
    public String[] getPropertyNames() {
        return ((CompositeType)this.type).getPropertyNames();
    }

    @Override
    public UserType getUserType() {
        return ((CustomType)this.type).getUserType();
    }

    @Override
    public boolean isCustomType() {
        return this.type instanceof CustomType;
    }

    @Override
    public boolean isComponentType() {
        return this.type instanceof ComponentType;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HibernateType that = (HibernateType)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hashCode(this.type);
    }
}

