/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore;

import com.atlassian.confluence.core.BodyTypeUserType;
import com.atlassian.confluence.core.persistence.hibernate.CustomClobType;
import com.atlassian.confluence.core.persistence.hibernate.InstantType;
import com.atlassian.confluence.impl.backuprestore.helpers.TableAndFieldNameValidator;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateField;
import com.atlassian.confluence.impl.backuprestore.restore.domain.ImportedObjectV2;
import com.atlassian.confluence.impl.hibernate.SpoolingBlobInputStreamType;
import com.atlassian.confluence.labels.persistence.dao.hibernate.NamespaceUserType;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.persistence.dao.hibernate.CryptographicKeyType;
import com.atlassian.confluence.security.persistence.dao.hibernate.KeyTransferBean;
import com.atlassian.confluence.spaces.persistence.dao.hibernate.SpaceStatusUserType;
import com.atlassian.confluence.spaces.persistence.dao.hibernate.SpaceTypeUserType;
import com.atlassian.confluence.user.persistence.dao.hibernate.UserKeyUserType;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.hibernate.BucketClobStringType;
import com.atlassian.sal.api.user.UserKey;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityInfoSqlHelper {
    private static final Logger log = LoggerFactory.getLogger(EntityInfoSqlHelper.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private final TableAndFieldNameValidator tableAndFieldNameValidator = new TableAndFieldNameValidator();
    private final Map<Class<?>, String> insertStatementByEntityClass = new ConcurrentHashMap();

    public String getInsertQuery(ExportableEntityInfo entityInfo) {
        return this.insertStatementByEntityClass.computeIfAbsent(entityInfo.getEntityClass(), aClass -> this.buildSqlInsertStatement(entityInfo));
    }

    private String buildSqlInsertStatement(ExportableEntityInfo entityInfo) {
        String discriminatorColumnName;
        ArrayList<String> columnNames = new ArrayList<String>();
        if (entityInfo.getId() != null) {
            columnNames.addAll(entityInfo.getId().getColumnNames());
        }
        if ((discriminatorColumnName = entityInfo.getDiscriminatorColumnName()) != null) {
            columnNames.add(discriminatorColumnName);
        }
        for (HibernateField field : entityInfo.getPersistableFields()) {
            columnNames.addAll(field.getColumnNames());
        }
        StringBuilder columnNamesBuilder = new StringBuilder();
        StringBuilder valuesBuilder = new StringBuilder();
        for (int i = 0; i < columnNames.size(); ++i) {
            if (i > 0) {
                columnNamesBuilder.append(", ");
                valuesBuilder.append(", ");
            }
            columnNamesBuilder.append(TableAndFieldNameValidator.checkNameDoesNotHaveSqlInjections((String)columnNames.get(i)));
            valuesBuilder.append(":");
            valuesBuilder.append(TableAndFieldNameValidator.checkNameDoesNotHaveSqlInjections(EntityInfoSqlHelper.stripQuotesFromName((String)columnNames.get(i))));
        }
        String sql = "INSERT INTO " + TableAndFieldNameValidator.checkNameDoesNotHaveSqlInjections(entityInfo.getTableName()) + " (" + String.valueOf(columnNamesBuilder) + ") VALUES (" + String.valueOf(valuesBuilder) + " )";
        log.trace("Sql insert script for entity {}: {}", (Object)entityInfo.getEntityClass().getSimpleName(), (Object)sql);
        return sql;
    }

    public Map<String, Object> createValuesForInsert(ImportedObjectV2 importedObject) {
        List<HibernateField> fields = importedObject.getEntityInfo().getPersistableFields();
        HashMap<String, Object> valuesForOneRecord = new HashMap<String, Object>();
        valuesForOneRecord.putAll(this.generateIdValuesForInsert(importedObject));
        String discriminatorColumnName = importedObject.getEntityInfo().getDiscriminatorColumnName();
        if (discriminatorColumnName != null) {
            valuesForOneRecord.put(discriminatorColumnName, importedObject.getEntityInfo().getDiscriminatorValue());
        }
        for (HibernateField field : fields) {
            String propertyName = field.getPropertyName();
            field.getColumnNames().forEach(columnName -> {
                Object dbReadyValue = EntityInfoSqlHelper.getDbReadyValueFromProperty(importedObject.getFieldValue(propertyName));
                if (dbReadyValue instanceof KeyTransferBean) {
                    dbReadyValue = this.getKeyTransferBeanColumnValues((String)columnName, dbReadyValue);
                }
                valuesForOneRecord.put((String)columnName, dbReadyValue);
            });
        }
        return valuesForOneRecord.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(EntityInfoSqlHelper.stripQuotesFromName((String)v.getKey()), v.getValue()), HashMap::putAll);
    }

    private Object getKeyTransferBeanColumnValues(String columnName, Object dbReadyValue) {
        return switch (columnName) {
            case "TYPE" -> ((KeyTransferBean)dbReadyValue).getKeyType();
            case "ALGORITHM" -> ((KeyTransferBean)dbReadyValue).getAlgorithm();
            case "KEYSPEC" -> ((KeyTransferBean)dbReadyValue).getEncodedKey();
            default -> dbReadyValue;
        };
    }

    private Map<String, Object> generateIdValuesForInsert(ImportedObjectV2 importedObject) {
        if (importedObject.getId() == null) {
            return Collections.emptyMap();
        }
        HibernateField idField = importedObject.getEntityInfo().getId();
        return importedObject.getCompositeId().map(compositeId -> EntityInfoSqlHelper.generateCompositeIdValuesForInsert(compositeId, idField)).orElseGet(() -> Map.of(idField.getColumnNames().get(0), EntityInfoSqlHelper.getDbReadyValueFromProperty(importedObject.getId())));
    }

    private static Map<String, Object> generateCompositeIdValuesForInsert(Map<String, Object> compositeId, HibernateField idField) {
        LinkedHashMap<String, Object> valuesForId = new LinkedHashMap<String, Object>();
        for (String columnName : idField.getColumnNames()) {
            String propertyName = idField.getPropertyName(columnName);
            Object idValue = compositeId.get(propertyName);
            valuesForId.put(columnName, EntityInfoSqlHelper.getDbReadyValueFromProperty(idValue));
        }
        return valuesForId;
    }

    public Object convertToDbReadyValue(HibernateField.Type type, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        if (type.isCustomType()) {
            return this.convertCustomTypeToDbReadyValue(value, type.getUserType());
        }
        if (type.isComponentType()) {
            return this.convertComponentTypeToDbReadyValue(type, value);
        }
        try {
            if (type.matches((Type)StandardBasicTypes.INTEGER)) {
                return Integer.parseInt(value);
            }
            if (type.matches((Type)StandardBasicTypes.LONG)) {
                return Long.parseLong(value);
            }
            if (type.matches((Type)StandardBasicTypes.BIG_INTEGER)) {
                return Long.parseLong(value);
            }
            if (type.matches((Type)StandardBasicTypes.STRING)) {
                return GeneralUtil.unescapeCDATA(value);
            }
            if (type.matches((Type)StandardBasicTypes.TEXT)) {
                return GeneralUtil.unescapeCDATA(value);
            }
            if (type.matches((Type)StandardBasicTypes.DOUBLE)) {
                return Double.parseDouble(value);
            }
            if (type.matches((Type)StandardBasicTypes.TIMESTAMP)) {
                return this.convertToTimestamp(value);
            }
            if (type.matches((Type)org.hibernate.type.InstantType.INSTANCE)) {
                return this.convertInstantToTimestamp(value);
            }
            if (type.matches((Type)StandardBasicTypes.BOOLEAN)) {
                return Boolean.parseBoolean(value);
            }
            if (type.matches((Type)StandardBasicTypes.CHARACTER)) {
                return value;
            }
            if (type.matches((Type)StandardBasicTypes.TRUE_FALSE)) {
                return String.valueOf(value.toUpperCase().charAt(0));
            }
            log.warn("Unexpected type came for parsing. Null value will be used instead. Type: {}, value: {}", (Object)type, (Object)value);
            return null;
        }
        catch (IllegalArgumentException | ParseException e) {
            log.warn("Unable to parse value, null value will be used instead. Type: {}, value: {}. Exception: {}", new Object[]{type, value, e.toString()});
            return null;
        }
    }

    public Object convertCustomTypeToDbReadyValue(String value, UserType userType) {
        if (userType.getClass().equals(UserKeyUserType.class)) {
            return GeneralUtil.unescapeCDATA(value);
        }
        if (userType.getClass().equals(SpaceTypeUserType.class)) {
            return value;
        }
        if (userType.getClass().equals(SpaceStatusUserType.class)) {
            return value;
        }
        if (userType.getClass().equals(BucketClobStringType.class)) {
            return GeneralUtil.unescapeCDATA(value);
        }
        if (userType.getClass().equals(CustomClobType.class)) {
            return GeneralUtil.unescapeCDATA(value);
        }
        if (userType.getClass().equals(NamespaceUserType.class)) {
            return GeneralUtil.unescapeCDATA(value);
        }
        if (userType.getClass().equals(BodyTypeUserType.class)) {
            return Integer.parseInt(value);
        }
        if (userType.getClass().equals(SpoolingBlobInputStreamType.class)) {
            return GeneralUtil.unescapeCDATA(value).getBytes(StandardCharsets.UTF_8);
        }
        if (userType.getClass().equals(CryptographicKeyType.class)) {
            return new KeyTransferBean(KeyTransferBean.CDatafyString(value));
        }
        if (userType.getClass().equals(InstantType.class)) {
            return Long.parseLong(value);
        }
        throw new IllegalArgumentException("Unexpected custom type with user type " + String.valueOf(userType));
    }

    private Object convertComponentTypeToDbReadyValue(HibernateField.Type type, String value) {
        if (type.getPropertyNames().length > 1) {
            throw new IllegalArgumentException(String.format("Unexpected ComponentType with multiple columns. Type: %s, Value: %s", type, value));
        }
        if (type.getReturnedClass().equals(PasswordCredential.class)) {
            return value;
        }
        log.warn("Unexpected Component property type came for parsing. Null value will be used instead. Type: {}, value: {}", (Object)type, (Object)value);
        return null;
    }

    private Timestamp convertToTimestamp(String dateAsString) throws ParseException {
        Date parsedDate = new SimpleDateFormat(DATE_FORMAT).parse(dateAsString);
        return new Timestamp(parsedDate.getTime());
    }

    private Date convertInstantToTimestamp(String instantAsString) throws DateTimeParseException {
        if (instantAsString.contains("Z")) {
            Instant parsedInstant = Instant.parse(instantAsString);
            return Timestamp.from(parsedInstant);
        }
        String newString = instantAsString.replace(" ", "T");
        newString = newString.concat("Z");
        Instant parsedInstant = Instant.parse(newString);
        return Timestamp.from(parsedInstant);
    }

    public static Object getDbReadyValueFromProperty(Object property) {
        if (property instanceof UserKey) {
            return ((UserKey)property).getStringValue();
        }
        if (property instanceof ContentTypeEnum) {
            return ((ContentTypeEnum)((Object)property)).getRepresentation();
        }
        return property;
    }

    protected static String stripQuotesFromName(String name) {
        return StringUtils.strip((String)name, (String)"\"'");
    }
}

