/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.backuprestore.JobOperation;
import com.atlassian.confluence.api.model.backuprestore.JobScope;
import com.atlassian.confluence.api.model.backuprestore.JobState;
import com.atlassian.confluence.backuprestore.BackupRestoreJob;
import com.atlassian.confluence.backuprestore.BackupRestoreSettings;
import com.atlassian.confluence.backuprestore.exception.BackupRestoreException;
import com.atlassian.confluence.backuprestore.exception.SpaceKeyExistBackupRestoreException;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.impl.backuprestore.ParallelTasksExecutor;
import com.atlassian.confluence.impl.backuprestore.ParallelTasksExecutorFactory;
import com.atlassian.confluence.impl.backuprestore.dao.BackupRestoreJobDao;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfoFactory;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateMetadataHelper;
import com.atlassian.confluence.impl.backuprestore.restore.BackupPropertiesValidator;
import com.atlassian.confluence.impl.backuprestore.restore.HiLoGeneratorInitialiserOnSiteRestore;
import com.atlassian.confluence.impl.backuprestore.restore.ImportedObjectsDispatcher;
import com.atlassian.confluence.impl.backuprestore.restore.ImportedObjectsDispatcherFactory;
import com.atlassian.confluence.impl.backuprestore.restore.container.BackupContainerReader;
import com.atlassian.confluence.impl.backuprestore.restore.container.BackupContainerReaderFactory;
import com.atlassian.confluence.impl.backuprestore.restore.container.BackupProperties;
import com.atlassian.confluence.impl.backuprestore.restore.dao.RestoreDao;
import com.atlassian.confluence.impl.backuprestore.restore.domain.ImportedObjectV2;
import com.atlassian.confluence.impl.backuprestore.restore.events.OnRestoreEventsSender;
import com.atlassian.confluence.impl.backuprestore.restore.searchindexer.OnRestoreSearchIndexer;
import com.atlassian.confluence.impl.backuprestore.restore.searchindexer.OnRestoreSearchIndexerFactory;
import com.atlassian.confluence.impl.backuprestore.restore.taskrunners.ImportTaskRunner;
import com.atlassian.confluence.impl.backuprestore.restore.taskrunners.ImportTaskRunnerFactory;
import com.atlassian.confluence.impl.backuprestore.restore.taskrunners.SiteRestoreJobResurrector;
import com.atlassian.confluence.impl.backuprestore.statistics.OnObjectsProcessingHandler;
import com.atlassian.confluence.impl.backuprestore.statistics.SkippedObjectsReason;
import com.atlassian.confluence.impl.backuprestore.statistics.StatisticsCollector;
import com.atlassian.confluence.impl.backuprestore.statistics.StatisticsCollectorFactory;
import com.atlassian.confluence.impl.cache.CacheFlusher;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreService {
    private static final Logger log = LoggerFactory.getLogger(RestoreService.class);
    private final EventPublisher eventPublisher;
    private final BackupContainerReaderFactory backupContainerReaderFactory;
    private final ImportedObjectsDispatcherFactory importedObjectsDispatcherFactory;
    private final ExportableEntityInfoFactory exportableEntityInfoFactory;
    private final SessionFactory sessionFactory;
    private final OnRestoreEventsSender onRestoreEventsSender;
    private final ImportTaskRunnerFactory importTaskRunnerFactory;
    private final BackupPropertiesValidator backupPropertiesValidator;
    private final OnRestoreSearchIndexerFactory onRestoreSearchIndexerFactory;
    private final BackupRestoreJobDao backupRestoreJobDao;
    private final ReentrantLock restoreLock = new ReentrantLock();
    private final RestoreDao restoreDao;
    private final SpaceManagerInternal spaceManager;
    private final CacheFlusher cacheFlusher;
    private final HiLoGeneratorInitialiserOnSiteRestore hiLoGeneratorInitialiserOnSiteRestore;
    private final StatisticsCollectorFactory statisticsCollectorFactory;
    private final ParallelTasksExecutorFactory parallelTasksExecutorFactory;
    private final SiteRestoreJobResurrector siteRestoreJobResurrector;

    public RestoreService(SessionFactory sessionFactory, BackupContainerReaderFactory backupContainerReaderFactory, ImportedObjectsDispatcherFactory importedObjectsDispatcherFactory, OnRestoreEventsSender onRestoreEventsSender, ExportableEntityInfoFactory exportableEntityInfoFactory, ImportTaskRunnerFactory importTaskRunnerFactory, BackupPropertiesValidator backupPropertiesValidator, OnRestoreSearchIndexerFactory onRestoreSearchIndexerFactory, RestoreDao restoreDao, BackupRestoreJobDao backupRestoreJobDao, SpaceManagerInternal spaceManager, CacheFlusher cacheFlusher, EventPublisher eventPublisher, HiLoGeneratorInitialiserOnSiteRestore hiLoGeneratorInitialiserOnSiteRestore, StatisticsCollectorFactory statisticsCollectorFactory, ParallelTasksExecutorFactory parallelTasksExecutorFactory, SiteRestoreJobResurrector siteRestoreJobResurrector) {
        this.eventPublisher = eventPublisher;
        this.backupContainerReaderFactory = backupContainerReaderFactory;
        this.onRestoreEventsSender = onRestoreEventsSender;
        this.importedObjectsDispatcherFactory = importedObjectsDispatcherFactory;
        this.exportableEntityInfoFactory = exportableEntityInfoFactory;
        this.sessionFactory = sessionFactory;
        this.importTaskRunnerFactory = importTaskRunnerFactory;
        this.backupPropertiesValidator = backupPropertiesValidator;
        this.onRestoreSearchIndexerFactory = onRestoreSearchIndexerFactory;
        this.restoreDao = restoreDao;
        this.backupRestoreJobDao = backupRestoreJobDao;
        this.spaceManager = spaceManager;
        this.cacheFlusher = cacheFlusher;
        this.hiLoGeneratorInitialiserOnSiteRestore = hiLoGeneratorInitialiserOnSiteRestore;
        this.statisticsCollectorFactory = statisticsCollectorFactory;
        this.parallelTasksExecutorFactory = parallelTasksExecutorFactory;
        this.siteRestoreJobResurrector = siteRestoreJobResurrector;
    }

    public void doRestore(BackupRestoreJob job, BackupRestoreSettings settings, int threadsNumber) throws BackupRestoreException, InterruptedException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        JobScope restoreJobScope = job.getJobScope();
        Long restoreJobId = job.getId();
        log.info("{} restore [{}] has started.", (Object)restoreJobScope, (Object)restoreJobId);
        String fileName = settings.getFileName();
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            throw new BackupRestoreException("File name can't be empty");
        }
        this.restoreLock.lock();
        try (ParallelTasksExecutor parallelTasksExecutor = this.parallelTasksExecutorFactory.create(job, threadsNumber);
             ImportTaskRunner importTaskRunner = this.importTaskRunnerFactory.createImportTaskRunner(job.getJobScope());){
            try {
                HibernateMetadataHelper hibernateMetadataHelper = new HibernateMetadataHelper(this.exportableEntityInfoFactory, this.sessionFactory, false);
                OnRestoreSearchIndexer searchIndexer = this.onRestoreSearchIndexerFactory.createOnRestoreSearchIndexer(restoreJobScope, parallelTasksExecutor);
                this.readAllObjectsAndRestore(job, settings, stopwatch, new JobInfo(job), restoreJobId, parallelTasksExecutor, importTaskRunner, hibernateMetadataHelper, searchIndexer);
            }
            catch (Exception e) {
                log.debug("Start interrupting all tasks");
                parallelTasksExecutor.interruptAllJobs();
                throw e;
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            this.onRestoreEventsSender.sendFailureEvent(e.getMessage(), job.getJobScope());
            throw new BackupRestoreException(e);
        }
        finally {
            this.restoreLock.unlock();
            log.info("{} restore [{}] completed", (Object)job.getJobScope(), (Object)job.getId());
        }
    }

    private void readAllObjectsAndRestore(BackupRestoreJob job, BackupRestoreSettings settings, Stopwatch stopwatch, JobInfo jobInfo, Long restoreJobId, ParallelTasksExecutor parallelTasksExecutor, ImportTaskRunner importTaskRunner, HibernateMetadataHelper hibernateMetadataHelper, OnRestoreSearchIndexer searchIndexer) throws BackupRestoreException, ExecutionException, InterruptedException, TimeoutException {
        BackupRestoreJob jobEntity = job;
        try (BackupContainerReader containerReader = this.backupContainerReaderFactory.createBackupContainerReader(new File(settings.getFilePath()));){
            StatisticsCollector jobStatisticsInfo;
            BackupProperties backupProperties = this.backupPropertiesValidator.validatePropertiesAgainstBackupJob(jobInfo.scope, containerReader.getBackupProperties());
            jobEntity.addSpaceKeys(backupProperties.getSpaceKeys());
            jobEntity = switch (jobInfo.scope) {
                default -> throw new MatchException(null, null);
                case JobScope.SPACE -> this.validateSpaceKeys(jobEntity, backupProperties, parallelTasksExecutor);
                case JobScope.SITE -> jobEntity;
            };
            log.info("{} restore [{}] setup and validation completed.", (Object)jobInfo.scope, (Object)restoreJobId);
            this.onRestoreEventsSender.sendStartEvents(settings, backupProperties.getSpaceKeys(), containerReader.getLegacyBackupProperties(), jobInfo.scope, jobInfo.owner);
            log.info("{} restore [{}] running pre-import tasks.", (Object)jobInfo.scope, (Object)restoreJobId);
            importTaskRunner.runPreImportTasks();
            if (jobInfo.scope.equals((Object)JobScope.SITE)) {
                this.siteRestoreJobResurrector.resurrectSiteRestoreJob(jobEntity, settings, this.hiLoGeneratorInitialiserOnSiteRestore);
            }
            log.info("{} restore [{}] pre-import tasks completed.", (Object)jobInfo.scope, (Object)restoreJobId);
            try (StatisticsCollector statisticsCollector = this.statisticsCollectorFactory.createStatisticsCollector(restoreJobId, jobInfo.scope, jobInfo.operation, this.eventPublisher, this.backupRestoreJobDao, parallelTasksExecutor);){
                statisticsCollector.createEmptyStatisticsRecord();
                RestoreService.retrieveTotalObjectsFromBackupDescriptorAndUpdateStatistics(backupProperties, statisticsCollector);
                ImportedObjectsDispatcher importedObjectsDispatcher = this.importedObjectsDispatcherFactory.createImportedObjectsDispatcher(jobInfo.scope, backupProperties.getJobSource(), JobScope.SPACE.equals((Object)jobInfo.scope) ? Optional.of(new HashSet<String>(backupProperties.getSpaceKeys())) : Optional.empty(), settings.getFilePath(), parallelTasksExecutor, hibernateMetadataHelper, new OnObjectsProcessingHandlerImpl(searchIndexer, statisticsCollector), backupProperties.getBackupAttachments());
                log.info("{} restore [{}] starting reading all XML objects from {}.", new Object[]{jobInfo.scope, restoreJobId, jobInfo.filename});
                this.readInputObjectsAndUpdateNextHiValueSynchronously(jobInfo.scope, parallelTasksExecutor, statisticsCollector, containerReader, importedObjectsDispatcher);
                log.info("{} restore [{}] finished reading all XML objects from {}.", new Object[]{jobInfo.scope, restoreJobId, jobInfo.filename});
                log.info("{} restore [{}] processing remaining gathered objects.", (Object)jobInfo.scope, (Object)restoreJobId);
                RestoreService.processDataFromAllStashes(parallelTasksExecutor, importedObjectsDispatcher);
                importedObjectsDispatcher.runDeferredOperations();
                parallelTasksExecutor.waitUntilAllGlobalJobsComplete();
                jobEntity = this.backupRestoreJobDao.getById(jobEntity.getId());
                jobEntity.setJobState(JobState.COMPLETING);
                this.backupRestoreJobDao.updateInNewTransaction(jobEntity);
                log.info("{} restore [{}] processing plugin data sync.", (Object)jobInfo.scope, (Object)restoreJobId);
                parallelTasksExecutor.runGlobalTaskAsync(() -> {
                    this.readPluginData(jobInfo.scope, containerReader);
                    return null;
                }, "importing plugin data");
                parallelTasksExecutor.waitUntilAllGlobalJobsComplete();
                log.info("{} restore [{}] running post-import tasks.", (Object)jobInfo.scope, (Object)restoreJobId);
                importTaskRunner.runPostImportTasks(settings, backupProperties);
                if (!settings.isSkipReindex()) {
                    searchIndexer.flush();
                }
                jobStatisticsInfo = statisticsCollector;
            }
            parallelTasksExecutor.waitUntilAllGlobalJobsComplete();
            Thread.sleep(1000L);
            this.cacheFlusher.flushCaches();
            this.onRestoreEventsSender.sendFinishEvents(settings, backupProperties.getSpaceKeys(), containerReader.getLegacyBackupProperties(), jobInfo.scope, jobInfo.owner);
            log.info("{} restore [{}] ended in {}. Processed {} objects, accepted {} of them.", new Object[]{jobInfo.scope, restoreJobId, stopwatch, jobStatisticsInfo.getProcessedObjectsCounter(), jobStatisticsInfo.getPersistedObjectsCount()});
        }
    }

    private BackupRestoreJob validateSpaceKeys(BackupRestoreJob job, BackupProperties backupProperties, ParallelTasksExecutor parallelTasksExecutor) throws BackupRestoreException, ExecutionException, InterruptedException {
        Collection<String> spaceKeysCollection = backupProperties.getSpaceKeys();
        this.checkThatRestoredSpacesDoNotExistInTheDatabase(spaceKeysCollection);
        Callable<BackupRestoreJob> task = () -> {
            BackupRestoreJob currentJob = this.backupRestoreJobDao.getById(job.getId());
            currentJob.addSpaceKeys(spaceKeysCollection);
            this.backupRestoreJobDao.update(currentJob);
            return currentJob;
        };
        return parallelTasksExecutor.runTaskAsync(task, "Update space keys").get();
    }

    private void readInputObjectsAndUpdateNextHiValueSynchronously(JobScope jobScope, ParallelTasksExecutor parallelTasksExecutor, StatisticsCollector statisticsCollector, BackupContainerReader containerReader, ImportedObjectsDispatcher importedObjectsDispatcher) throws BackupRestoreException, ExecutionException, InterruptedException, TimeoutException {
        AtomicLong readObjectCounter = new AtomicLong();
        containerReader.readObjects(importedObject -> {
            if (importedObjectsDispatcher.processIncomingImportedObject((ImportedObjectV2)importedObject)) {
                this.hiLoGeneratorInitialiserOnSiteRestore.registerNewId(importedObject.getId());
            } else {
                statisticsCollector.onObjectSkipping(Collections.singleton(importedObject), SkippedObjectsReason.PERSISTER_NOT_FOUND);
            }
            readObjectCounter.incrementAndGet();
        });
        parallelTasksExecutor.waitUntilAllStageJobsComplete();
        if (JobScope.SITE.equals((Object)jobScope)) {
            this.hiLoGeneratorInitialiserOnSiteRestore.updateHiLoIdGenerator();
            this.onRestoreEventsSender.sendUnlockDatabaseEvent();
        }
        this.cacheFlusher.flushCaches();
        statisticsCollector.setTotalNumberOfObjects(readObjectCounter.get());
    }

    private void checkThatRestoredSpacesDoNotExistInTheDatabase(Collection<String> spaceKeys) throws BackupRestoreException {
        List existingSpaceKeys = spaceKeys.stream().map(this.spaceManager::getSpace).filter(Objects::nonNull).map(Space::getKey).collect(Collectors.toList());
        if (!existingSpaceKeys.isEmpty()) {
            String message = "Space(s) with the keys '%s' already exist. Please delete them before restoring a space with the same key(s).";
            throw new SpaceKeyExistBackupRestoreException(String.format("Space(s) with the keys '%s' already exist. Please delete them before restoring a space with the same key(s).", String.join((CharSequence)", ", existingSpaceKeys)));
        }
    }

    private static void processDataFromAllStashes(ParallelTasksExecutor parallelTasksExecutor, ImportedObjectsDispatcher importedObjectsDispatcher) throws BackupRestoreException, ExecutionException, InterruptedException, TimeoutException {
        int phaseCounter = 0;
        while (importedObjectsDispatcher.processNextStashPhase()) {
            parallelTasksExecutor.waitUntilAllStageJobsComplete();
            log.debug("The current phase {} has been finished", (Object)phaseCounter);
        }
        log.debug("All stashes have been processed in {} phases.", (Object)phaseCounter);
    }

    private static void retrieveTotalObjectsFromBackupDescriptorAndUpdateStatistics(BackupProperties backupProperties, StatisticsCollector statisticsCollector) {
        backupProperties.getTotalNumberOfObjects().ifPresent(statisticsCollector::setTotalNumberOfObjects);
    }

    private void readPluginData(JobScope jobScope, BackupContainerReader containerReader) {
        if (JobScope.SPACE.equals((Object)jobScope)) {
            return;
        }
        this.restoreDao.doInTransaction(tx -> {
            try {
                containerReader.readPluginModuleData();
                log.info("Finished processing plugin data");
            }
            catch (BackupRestoreException e) {
                throw new RuntimeException("Unable to restore plugin data: " + e.getMessage(), e);
            }
            return null;
        });
    }

    record JobInfo(JobScope scope, JobOperation operation, String owner, String filename) {
        JobInfo(BackupRestoreJob entity) {
            this(entity.getJobScope(), entity.getJobOperation(), entity.getOwner(), entity.getFileName());
        }
    }

    @VisibleForTesting
    static class OnObjectsProcessingHandlerImpl
    implements OnObjectsProcessingHandler {
        private final OnRestoreSearchIndexer onRestoreSearchIndexer;
        private final StatisticsCollector statisticsCollector;

        OnObjectsProcessingHandlerImpl(OnRestoreSearchIndexer onRestoreSearchIndexer, StatisticsCollector statisticsCollector) {
            this.onRestoreSearchIndexer = onRestoreSearchIndexer;
            this.statisticsCollector = statisticsCollector;
        }

        @Override
        public void onObjectsPersist(Collection<ImportedObjectV2> persistedObjects) throws BackupRestoreException {
            this.onRestoreSearchIndexer.onObjectsPersisting(persistedObjects);
            this.statisticsCollector.onObjectPersisting(persistedObjects);
        }

        @Override
        public void onObjectsSkipping(Collection<ImportedObjectV2> skippedObjects, SkippedObjectsReason reason) {
            this.statisticsCollector.onObjectSkipping(skippedObjects, reason);
        }

        @Override
        public void onObjectsReusing(Collection<ImportedObjectV2> reusedObjects) {
            this.statisticsCollector.onObjectReusing(reusedObjects);
        }
    }
}

