/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.container;

import com.atlassian.confluence.backuprestore.exception.BackupRestoreException;
import com.atlassian.confluence.impl.backuprestore.restore.container.BackupContainerReader;
import com.atlassian.confluence.impl.backuprestore.restore.container.BackupContainerReaderFactory;
import com.atlassian.confluence.impl.backuprestore.restore.container.PluginDataReader;
import com.atlassian.confluence.impl.backuprestore.restore.container.XMLBackupContainerReader;
import com.atlassian.confluence.impl.backuprestore.restore.preprocessing.ImportedObjectV1ToV2Converter;
import com.atlassian.confluence.importexport.plugin.BackupRestoreProviderManager;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.plugin.PluginAccessor;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import java.util.zip.ZipFile;

public class BackupContainerReaderFactoryImpl
implements BackupContainerReaderFactory {
    private final Supplier<ImportedObjectV1ToV2Converter> importedObjectV1ToV2ConverterLazyReference = MemoizingComponentReference.containerComponent("importedObjectV1ToV2Converter");
    private final Supplier<BackupRestoreProviderManager> backupRestoreProviderManagerLazyReferencee = MemoizingComponentReference.containerComponent("backupRestoreProviderManager");
    private final Supplier<PluginAccessor> pluginAccessorLazyReference = MemoizingComponentReference.containerComponent("pluginAccessor");

    @Override
    public BackupContainerReader createBackupContainerReader(File file) throws BackupRestoreException {
        try {
            if (!file.exists()) {
                throw new BackupRestoreException("Backup file not found: " + file.getCanonicalPath());
            }
            ZipFile zipFile = new ZipFile(file);
            PluginDataReader pluginDataReader = new PluginDataReader(zipFile, this.backupRestoreProviderManagerLazyReferencee.get(), this.pluginAccessorLazyReference.get());
            return new XMLBackupContainerReader(zipFile, this.importedObjectV1ToV2ConverterLazyReference.get(), pluginDataReader);
        }
        catch (IOException e) {
            throw new BackupRestoreException(e);
        }
    }
}

