/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.dao;

import com.atlassian.confluence.impl.backuprestore.restore.dao.RestoreDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.id.IdentifierGenerator;

public class SmartIdGenerator {
    private final RestoreDao restoreDao;
    private final Map<IdentifierGenerator, LinkedList<Object>> generatedIds = new ConcurrentHashMap<IdentifierGenerator, LinkedList<Object>>();
    private static final int MIN_NUMBER_OF_IDS_TO_GENERATE = 10;
    private static final int MAX_NUMBER_OF_IDS_TO_GENERATE = 500;
    private static final int MULTIPLICATION_FACTOR_TO_GENERATE_IDS = 2;
    public static final int TIMEOUT_LOCK_MINUTES = 10;
    private final Map<IdentifierGenerator, ReentrantLock> locks = new ConcurrentHashMap<IdentifierGenerator, ReentrantLock>();

    public SmartIdGenerator(RestoreDao restoreDao) {
        this.restoreDao = restoreDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> generateIds(IdentifierGenerator identifierGenerator, Object fakeObject, int numberOfIdsToGenerate) {
        if (numberOfIdsToGenerate < 0) {
            throw new IllegalStateException("generateIds: number of ids cannot be negative");
        }
        if (numberOfIdsToGenerate == 0) {
            return Collections.emptyList();
        }
        ReentrantLock lock = this.locks.computeIfAbsent(identifierGenerator, x -> new ReentrantLock());
        try {
            if (!lock.tryLock(10L, TimeUnit.MINUTES)) {
                throw new IllegalStateException("Unable to retrieve locks for id generator in 10 minutes. identifierGenerator: " + String.valueOf(identifierGenerator));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
        try {
            LinkedList preGeneratedIds = this.generatedIds.computeIfAbsent(identifierGenerator, x -> new LinkedList());
            if (preGeneratedIds.size() < numberOfIdsToGenerate) {
                preGeneratedIds.addAll(this.restoreDao.generateIds(identifierGenerator, fakeObject, this.calculateNumberOfIdsToRetrieveFromDatabase(numberOfIdsToGenerate)));
            }
            ArrayList<Object> result = new ArrayList<Object>(numberOfIdsToGenerate);
            while (numberOfIdsToGenerate-- > 0) {
                result.add(preGeneratedIds.pop());
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    private int calculateNumberOfIdsToRetrieveFromDatabase(int numberOfIdsToGenerate) {
        if (numberOfIdsToGenerate < 10) {
            return 10;
        }
        if (numberOfIdsToGenerate > 500) {
            return numberOfIdsToGenerate;
        }
        return numberOfIdsToGenerate * 2;
    }
}

