/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.domain;

import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ImportedObjectV2
implements Serializable {
    private static final long serialVersionUID = 3070937942528383244L;
    final Map<String, Object> originalPropertyValueMap;
    private final Class<?> entityClass;
    private final transient ExportableEntityInfo entityInfo;
    private final Object id;

    public ImportedObjectV2 overridePropertyValues(Object newId, Map<String, Object> propertiesToOverride) {
        HashMap<String, Object> newProperties = new HashMap<String, Object>(this.originalPropertyValueMap);
        newProperties.putAll(propertiesToOverride);
        return new ImportedObjectV2(this.entityInfo, newId, newProperties);
    }

    public ImportedObjectV2(ExportableEntityInfo exportableEntityInfo, Object id, Map<String, Object> propertyValueMap) {
        Preconditions.checkArgument((!(id instanceof Collection) ? 1 : 0) != 0);
        this.id = id;
        this.entityClass = exportableEntityInfo.getEntityClass();
        this.entityInfo = exportableEntityInfo;
        this.originalPropertyValueMap = Collections.unmodifiableMap(propertyValueMap);
    }

    public ImportedObjectV2 clearValues(Collection<String> propertiesToClear) {
        HashMap<String, Object> newProperties = new HashMap<String, Object>(this.originalPropertyValueMap);
        for (String propertyName : propertiesToClear) {
            newProperties.remove(propertyName);
        }
        return new ImportedObjectV2(this.entityInfo, this.id, newProperties);
    }

    public ExportableEntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    public Object getFieldValue(String propertyName) {
        return this.originalPropertyValueMap.get(propertyName);
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Object getId() {
        return this.id;
    }

    public Optional<Map<String, Object>> getCompositeId() {
        Optional<Map<String, Object>> optional;
        Object object = this.id;
        if (object instanceof Map) {
            Map map = (Map)object;
            optional = Optional.of(map);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Map<String, Object> getPropertyValueMap() {
        return this.originalPropertyValueMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImportedObjectV2 that = (ImportedObjectV2)obj;
        return Objects.equals(this.entityClass, that.entityClass) && Objects.equals(this.entityInfo, that.entityInfo) && Objects.equals(this.id, that.id) && Objects.equals(this.originalPropertyValueMap, that.originalPropertyValueMap);
    }

    public int hashCode() {
        return Objects.hash(this.entityClass, this.entityInfo, this.id, this.originalPropertyValueMap);
    }

    public String toString() {
        return "ImportedObjectV2{id=" + String.valueOf(this.id) + ", entityClass=" + String.valueOf(this.entityClass) + ", originalPropertyValueMap=" + String.valueOf(this.originalPropertyValueMap) + "}";
    }
}

