/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.events;

import com.atlassian.confluence.api.model.backuprestore.JobScope;
import com.atlassian.confluence.backuprestore.BackupRestoreSettings;
import com.atlassian.confluence.backuprestore.exception.BackupRestoreException;
import com.atlassian.confluence.event.events.admin.AsyncImportFinishedEvent;
import com.atlassian.confluence.event.events.admin.AsyncImportStartedEvent;
import com.atlassian.confluence.event.events.admin.ImportFinishedEvent;
import com.atlassian.confluence.event.events.admin.RestoreFailedEvent;
import com.atlassian.confluence.event.events.admin.RestoreInProgressEvent;
import com.atlassian.confluence.event.events.admin.RestoreLockDatabaseEvent;
import com.atlassian.confluence.event.events.admin.RestoreSucceededEvent;
import com.atlassian.confluence.event.events.admin.RestoreUnlockDatabaseEvent;
import com.atlassian.confluence.impl.backuprestore.restore.confluencelocker.ConfluenceLockerOnSiteRestore;
import com.atlassian.confluence.impl.backuprestore.restore.dao.RestoreDao;
import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.ExportDescriptor;
import com.atlassian.confluence.importexport.impl.UnexpectedImportZipFileContents;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import java.util.Collection;
import java.util.Properties;

public class OnRestoreEventsSender {
    private final EventPublisher eventPublisher;
    private final UserAccessor userAccessor;
    private final RestoreDao restoreDao;

    public OnRestoreEventsSender(EventPublisher eventPublisher, UserAccessor userAccessor, RestoreDao restoreDao) {
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.restoreDao = restoreDao;
    }

    public void sendStartEvents(BackupRestoreSettings settings, Collection<String> spaceKeys, Properties properties, JobScope jobScope, String jobOwner) throws BackupRestoreException {
        try {
            switch (jobScope) {
                case SITE: {
                    this.sendInProgressEvent(jobScope, 0L, 0L, false, true);
                    this.sendStartSiteImportEvents(settings, properties, jobOwner);
                    break;
                }
                case SPACE: {
                    this.sendStartSpaceImportEvents(settings, spaceKeys, properties, jobOwner);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown job scope " + String.valueOf(jobScope));
                }
            }
        }
        catch (ImportExportException | UnexpectedImportZipFileContents e) {
            throw new BackupRestoreException("Unable to send events: " + e.getMessage(), e);
        }
    }

    public void sendFinishEvents(BackupRestoreSettings settings, Collection<String> spaceKeys, Properties properties, JobScope jobScope, String jobOwner) throws BackupRestoreException {
        try {
            switch (jobScope) {
                case SITE: {
                    this.sendFinishSiteImportEvents(settings, properties);
                    break;
                }
                case SPACE: {
                    this.sendFinishSpaceImportEvents(settings, spaceKeys, properties, jobOwner);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown job scope " + String.valueOf(jobScope));
                }
            }
        }
        catch (ImportExportException | UnexpectedImportZipFileContents e) {
            throw new BackupRestoreException("Unable to send events: " + e.getMessage(), e);
        }
        this.sendSuccessfulEvent(jobScope);
    }

    public void sendInProgressEvent(JobScope jobScope, long processedObjects, long totalNumberOfObjects, boolean databaseLocked, boolean isDisplayJohnson) {
        RestoreInProgressEvent event = new RestoreInProgressEvent(this, jobScope, processedObjects, totalNumberOfObjects, databaseLocked, isDisplayJohnson);
        this.eventPublisher.publish((Object)event);
    }

    public void sendLockDatabaseEvent() {
        this.eventPublisher.publish((Object)new RestoreLockDatabaseEvent(this, JobScope.SITE));
    }

    public void sendUnlockDatabaseEvent() {
        this.eventPublisher.publish((Object)new RestoreUnlockDatabaseEvent(this, JobScope.SITE));
    }

    public void sendSuccessfulEvent(JobScope jobScope) {
        this.eventPublisher.publish((Object)new RestoreSucceededEvent(this, jobScope));
    }

    public void sendFailureEvent(String errorMessage, JobScope jobScope) {
        this.eventPublisher.publish((Object)new RestoreFailedEvent(this, jobScope, errorMessage, ConfluenceLockerOnSiteRestore.isDisplayJohnson()));
    }

    private void sendStartSiteImportEvents(BackupRestoreSettings settings, Properties properties, String jobOwner) throws ImportExportException, UnexpectedImportZipFileContents {
        ExportDescriptor exportDescriptor = new ExportDescriptor(properties);
        ImportContext context = this.createImportContextForEvents(null, settings.getFileName(), exportDescriptor, jobOwner, settings.isSkipReindex());
        this.eventPublisher.publish((Object)new AsyncImportStartedEvent(this, context));
    }

    private void sendStartSpaceImportEvents(BackupRestoreSettings settings, Collection<String> spaceKeys, Properties properties, String jobOwner) throws ImportExportException, UnexpectedImportZipFileContents {
        ExportDescriptor exportDescriptor = new ExportDescriptor(properties);
        spaceKeys.forEach(spaceKey -> {
            ImportContext context = this.createImportContextForEvents((String)spaceKey, settings.getFileName(), exportDescriptor, jobOwner, settings.isSkipReindex());
            this.eventPublisher.publish((Object)new AsyncImportStartedEvent(this, context));
        });
    }

    private void sendFinishSiteImportEvents(BackupRestoreSettings settings, Properties properties) throws ImportExportException, UnexpectedImportZipFileContents {
        ExportDescriptor exportDescriptor = new ExportDescriptor(properties);
        ImportContext context = this.createImportContextForEvents(null, settings.getFileName(), exportDescriptor, null, settings.isSkipReindex());
        this.restoreDao.doInTransaction(tx -> {
            this.eventPublisher.publish((Object)new ImportFinishedEvent(this, context));
            return null;
        });
        this.eventPublisher.publish((Object)new AsyncImportFinishedEvent(this, context));
    }

    private void sendFinishSpaceImportEvents(BackupRestoreSettings settings, Collection<String> spaceKeys, Properties properties, String jobOwner) throws ImportExportException, UnexpectedImportZipFileContents {
        ExportDescriptor exportDescriptor = new ExportDescriptor(properties);
        spaceKeys.forEach(spaceKey -> {
            ImportContext context = this.createImportContextForEvents((String)spaceKey, settings.getFileName(), exportDescriptor, jobOwner, settings.isSkipReindex());
            this.restoreDao.doInTransaction(tx -> {
                this.eventPublisher.publish((Object)new ImportFinishedEvent(this, context));
                return null;
            });
            this.eventPublisher.publish((Object)new AsyncImportFinishedEvent(this, context));
        });
    }

    private ImportContext createImportContextForEvents(String spaceKey, String file, ExportDescriptor exportDescriptor, String userName, boolean isSkipReindex) {
        ConfluenceUser user = userName != null ? this.userAccessor.getUserByName(userName) : null;
        DefaultImportContext importContext = new DefaultImportContext(file, exportDescriptor, user);
        importContext.setDefaultSpaceKey(spaceKey);
        importContext.setSpaceKeyOfSpaceImport(spaceKey);
        importContext.setIncrementalImport(spaceKey != null);
        importContext.setDefaultUsersGroup(exportDescriptor.getDefaultUserGroup());
        importContext.setRebuildIndex(!isSkipReindex);
        return importContext;
    }
}

