/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.idmapping;

import bucket.user.propertyset.BucketPropertySetItem;
import com.atlassian.confluence.api.model.backuprestore.JobSource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateField;
import com.atlassian.confluence.impl.backuprestore.restore.EntityInfoSqlHelper;
import com.atlassian.confluence.impl.backuprestore.restore.dao.SmartIdGenerator;
import com.atlassian.confluence.impl.backuprestore.restore.domain.ImportedObjectV2;
import com.atlassian.confluence.impl.backuprestore.restore.idmapping.AbstractIdMapper;
import com.atlassian.confluence.impl.backuprestore.restore.idmapping.FakeObjectProvider;
import com.atlassian.confluence.impl.backuprestore.restore.idmapping.PersistedObjectsRegister;
import com.atlassian.confluence.impl.backuprestore.restore.idmapping.finders.ExistingEntityFinder;
import com.atlassian.confluence.impl.backuprestore.restore.idmapping.finders.ExistingEntityFindersProvider;
import com.atlassian.confluence.impl.backuprestore.statistics.OnObjectsProcessingHandler;
import com.atlassian.confluence.impl.plugin.settings.PluginSetting;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceRestoreIdMapper
extends AbstractIdMapper {
    private static final Logger log = LoggerFactory.getLogger(SpaceRestoreIdMapper.class);
    private final ExistingEntityFindersProvider entityFinderProvider;
    private final JobSource jobSource;
    private final FakeObjectProvider fakeObjectProvider;
    private final Map<Class<?>, XmlIdToDatabaseIdMap> idMap = new ConcurrentHashMap();
    private final OnObjectsProcessingHandler onObjectsProcessingHandler;
    private final SmartIdGenerator smartIdGenerator;

    public SpaceRestoreIdMapper(PersistedObjectsRegister persistedObjectsRegister, ExistingEntityFindersProvider entityFinderProvider, FakeObjectProvider fakeObjectProvider, JobSource jobSource, OnObjectsProcessingHandler onObjectsProcessingHandler, SmartIdGenerator smartIdGenerator) {
        super(persistedObjectsRegister);
        this.entityFinderProvider = entityFinderProvider;
        this.fakeObjectProvider = fakeObjectProvider;
        this.jobSource = jobSource;
        this.onObjectsProcessingHandler = onObjectsProcessingHandler;
        this.smartIdGenerator = smartIdGenerator;
    }

    @Override
    public Object getDatabaseId(Class<?> clazz, Object xmlId) {
        Class<?> entityClass = this.fixEntityClass(clazz);
        return this.idMap.computeIfAbsent(entityClass, eClass -> new XmlIdToDatabaseIdMap()).getDatabaseId(xmlId);
    }

    @Override
    public Collection<ImportedObjectV2> prepareObjectsToBePersisted(ExportableEntityInfo entityInfo, Collection<ImportedObjectV2> importedObjects) {
        StopWatch stopWatch = StopWatch.createStarted();
        Collection<ImportedObjectV2> importedObjectsWithNewIds = entityInfo.getEntityClass().equals(BucketPropertySetItem.class) ? this.replaceBucketPropertySetItemIds(importedObjects) : (entityInfo.getEntityClass().equals(PluginSetting.class) ? importedObjects : this.replaceIds(entityInfo, importedObjects));
        log.debug("Generated a collection of {} new ids of type {}. Duration: {}", new Object[]{importedObjects.size(), entityInfo.getEntityClass().getSimpleName(), stopWatch});
        return importedObjectsWithNewIds;
    }

    private Collection<ImportedObjectV2> replaceIds(ExportableEntityInfo entityInfo, Collection<ImportedObjectV2> importedObjects) {
        List<ImportedObjectV2> updatedImportedObjects = importedObjects.stream().map(importedObject -> {
            Map<String, Object> propertiesToOverride = this.createMapOfDatabaseIds((ImportedObjectV2)importedObject, importedObject.getEntityInfo().getAllExternalReferences());
            return importedObject.overridePropertyValues(importedObject.getId(), propertiesToOverride);
        }).toList();
        Map<ImportedObjectV2, Object> objectToDatabaseIdMap = this.generateOrFindDatabaseIds(entityInfo, updatedImportedObjects);
        return objectToDatabaseIdMap.entrySet().stream().map(entry -> ((ImportedObjectV2)entry.getKey()).overridePropertyValues(entry.getValue(), Collections.emptyMap())).toList();
    }

    private Collection<ImportedObjectV2> replaceBucketPropertySetItemIds(Collection<ImportedObjectV2> importedObjects) {
        return importedObjects.stream().map(item -> {
            Map<String, Object> xmlCompositeId = item.getCompositeId().orElseThrow();
            Object xmlEntityId = xmlCompositeId.get("entityId");
            Object databaseEntityId = this.getDatabaseId(ContentEntityObject.class, xmlEntityId);
            if (databaseEntityId != null) {
                Map newCompositeId = Maps.transformValues(xmlCompositeId, id -> id instanceof Long ? databaseEntityId : id);
                return item.overridePropertyValues(newCompositeId, Collections.emptyMap());
            }
            return item;
        }).collect(Collectors.toList());
    }

    private Map<ImportedObjectV2, Object> generateOrFindDatabaseIds(ExportableEntityInfo entityInfo, Collection<ImportedObjectV2> importingObjects) {
        HashSet<ImportedObjectV2> pendingImportingObjects = new HashSet<ImportedObjectV2>(importingObjects);
        ExistingEntityFinder existingEntityFinder = this.entityFinderProvider.getExistingEntityFinder(entityInfo.getEntityClass(), this.jobSource);
        if (existingEntityFinder != null) {
            String profileName = "generateOrFindDatabaseIds: usingEntityFinder: " + existingEntityFinder.getClass().getName();
            try (Ticker ignored = Timers.start((String)profileName);){
                Map<ImportedObjectV2, Object> importingObjectToNewIdMap = existingEntityFinder.findExistingObjectIds(importingObjects);
                for (Map.Entry<ImportedObjectV2, Object> importingObjectToNewIdEntry : importingObjectToNewIdMap.entrySet()) {
                    ImportedObjectV2 importingObject = importingObjectToNewIdEntry.getKey();
                    Object xmlId = importingObject.getId();
                    Object databaseId = EntityInfoSqlHelper.getDbReadyValueFromProperty(importingObjectToNewIdEntry.getValue());
                    pendingImportingObjects.remove(importingObject);
                    this.addXmlIdToDatabaseIdMapping(entityInfo.getEntityClass(), xmlId, databaseId);
                    this.markObjectsAsPersisted(entityInfo, Collections.singletonList(databaseId));
                    this.onObjectsProcessingHandler.onObjectsReusing(Collections.singleton(importingObjectToNewIdEntry.getKey()));
                }
            }
        }
        return this.generateDatabaseIds(entityInfo, pendingImportingObjects);
    }

    private Map<ImportedObjectV2, Object> generateDatabaseIds(ExportableEntityInfo entityInfo, Set<ImportedObjectV2> importingObjects) {
        if (importingObjects.isEmpty()) {
            return Collections.emptyMap();
        }
        if (entityInfo.getId() == null) {
            return importingObjects.stream().collect(HashMap::new, (map, value) -> map.put(value, null), HashMap::putAll);
        }
        Object fakeObject = this.fakeObjectProvider.getFakeObjectForIdGeneration(entityInfo.getEntityClass());
        Collection<Object> newlyGeneratedIds = this.smartIdGenerator.generateIds(entityInfo.getIdentifierGenerator(), fakeObject, importingObjects.size());
        if (newlyGeneratedIds.size() != importingObjects.size()) {
            throw new IllegalStateException("Requested to generate " + importingObjects.size() + " ids, but received " + newlyGeneratedIds.size());
        }
        HashMap<ImportedObjectV2, Object> importedObjectToDatabaseIdMap = new HashMap<ImportedObjectV2, Object>();
        Iterator<ImportedObjectV2> objectsIterator = importingObjects.iterator();
        for (Object databaseId : newlyGeneratedIds) {
            Object dbReadyDatabaseId = EntityInfoSqlHelper.getDbReadyValueFromProperty(databaseId);
            ImportedObjectV2 importedObjectV2 = objectsIterator.next();
            this.addXmlIdToDatabaseIdMapping(entityInfo.getEntityClass(), importedObjectV2.getId(), dbReadyDatabaseId);
            importedObjectToDatabaseIdMap.put(importedObjectV2, dbReadyDatabaseId);
        }
        return importedObjectToDatabaseIdMap;
    }

    private Map<String, Object> createMapOfDatabaseIds(ImportedObjectV2 importedObject, Collection<HibernateField> references) {
        HashMap<String, Object> mapOfDatabaseIds = new HashMap<String, Object>();
        for (HibernateField reference : references) {
            String propertyName = reference.getPropertyName();
            Object referencedValue = importedObject.getFieldValue(propertyName);
            if (referencedValue == null) continue;
            Object newReferenceValue = this.getDatabaseId(reference.getReferencedClass(), referencedValue);
            mapOfDatabaseIds.put(propertyName, EntityInfoSqlHelper.getDbReadyValueFromProperty(newReferenceValue));
        }
        return mapOfDatabaseIds;
    }

    private void addXmlIdToDatabaseIdMapping(Class<?> clazz, Object xmlId, Object databaseId) {
        Class<?> entityClass = this.fixEntityClass(clazz);
        this.idMap.computeIfAbsent(entityClass, eClass -> new XmlIdToDatabaseIdMap()).addDatabaseIdToXmlIdMapping(xmlId, databaseId);
    }

    private static class XmlIdToDatabaseIdMap {
        private final Map<Object, Object> idMap = new ConcurrentHashMap<Object, Object>();

        private XmlIdToDatabaseIdMap() {
        }

        void addDatabaseIdToXmlIdMapping(Object xmlId, Object databaseId) {
            this.idMap.put(xmlId, databaseId);
        }

        Object getDatabaseId(Object xmlId) {
            return this.idMap.get(xmlId);
        }
    }
}

