/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.preprocessing;

import com.atlassian.confluence.impl.backuprestore.restore.domain.ImportedObjectV2;
import com.atlassian.confluence.impl.backuprestore.restore.preprocessing.ImportedObjectPreprocessor;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DirectoryEntityObjectPreProcessor
implements ImportedObjectPreprocessor {
    private static final String KEY_DIR_PLACEHOLDER = "KEY_DIR";

    private String normalizeKeyDirPath(String pathString) {
        return pathString.replace("KEY_DIR\\\\", "KEY_DIR/");
    }

    private ImportedObjectV2 replaceApplicationPasswordKeyPath(ImportedObjectV2 importedObject) {
        Map<String, Object> propertyValueMap = importedObject.getPropertyValueMap();
        if (propertyValueMap == null) {
            return importedObject;
        }
        Map attributes = (Map)propertyValueMap.get("attributes");
        if (attributes == null) {
            return importedObject;
        }
        List<String> passWordAttributes = DirectoryImpl.PASSWORD_ATTRIBUTES.stream().filter(attributes::containsKey).toList();
        if (passWordAttributes.isEmpty()) {
            return importedObject;
        }
        passWordAttributes.forEach(attribute -> {
            String value = (String)attributes.get(attribute);
            if (value != null) {
                String updatedKeyPath = this.normalizeKeyDirPath(value);
                attributes.put(attribute, updatedKeyPath);
            }
        });
        return importedObject.overridePropertyValues(importedObject.getId(), attributes);
    }

    @Override
    public Optional<ImportedObjectV2> apply(ImportedObjectV2 importedObject) {
        if (DirectoryImpl.class.equals(importedObject.getEntityClass())) {
            return Optional.of(this.replaceApplicationPasswordKeyPath(importedObject));
        }
        return Optional.of(importedObject);
    }
}

