/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.preprocessing;

import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateField;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateMetadataHelper;
import com.atlassian.confluence.impl.backuprestore.restore.EntityInfoSqlHelper;
import com.atlassian.confluence.impl.backuprestore.restore.domain.ImportedObjectV2;
import com.atlassian.confluence.impl.backuprestore.restore.preprocessing.ClassExistenceValidator;
import com.atlassian.confluence.impl.backuprestore.restore.preprocessing.ImportedObjectFilter;
import com.atlassian.confluence.impl.backuprestore.restore.preprocessing.ImportedObjectPreprocessor;
import com.atlassian.confluence.importexport.xmlimport.model.CollectionProperty;
import com.atlassian.confluence.importexport.xmlimport.model.ComponentProperty;
import com.atlassian.confluence.importexport.xmlimport.model.CompositeId;
import com.atlassian.confluence.importexport.xmlimport.model.ContentTypeEnumProperty;
import com.atlassian.confluence.importexport.xmlimport.model.EnumProperty;
import com.atlassian.confluence.importexport.xmlimport.model.ImportedObject;
import com.atlassian.confluence.importexport.xmlimport.model.ImportedProperty;
import com.atlassian.confluence.importexport.xmlimport.model.PrimitiveId;
import com.atlassian.confluence.importexport.xmlimport.model.PrimitiveProperty;
import com.atlassian.confluence.importexport.xmlimport.model.ReferenceProperty;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.diagnostics.Severity;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportedObjectV1ToV2Converter
implements Function<ImportedObject, Optional<ImportedObjectV2>> {
    private static final Logger log = LoggerFactory.getLogger(ImportedObjectV1ToV2Converter.class);
    private final HibernateMetadataHelper hibernateMetadataHelper;
    private final EntityInfoSqlHelper entityInfoSqlHelper;
    private final Collection<ImportedObjectFilter> filters;
    private final Collection<ImportedObjectPreprocessor> preprocessors;
    private final ClassExistenceValidator classExistenceValidator = new ClassExistenceValidator();

    public ImportedObjectV1ToV2Converter(Collection<ImportedObjectFilter> filters, Collection<ImportedObjectPreprocessor> preprocessors, HibernateMetadataHelper hibernateMetadataHelper, EntityInfoSqlHelper entityInfoSqlHelper) {
        this.filters = filters;
        this.preprocessors = preprocessors;
        this.entityInfoSqlHelper = entityInfoSqlHelper;
        this.hibernateMetadataHelper = hibernateMetadataHelper;
    }

    public static ImportedObjectV2 fromLegacyImportedObject(ImportedObject legacyImportedObject, ExportableEntityInfo exportableEntityInfo, EntityInfoSqlHelper entityInfoSqlHelper, HibernateMetadataHelper hibernateMetadataHelper) throws ClassNotFoundException {
        Object originalId = ImportedObjectV1ToV2Converter.extractOriginalIdValue(legacyImportedObject.getIdProperty(), legacyImportedObject.getCompositeId(), exportableEntityInfo, entityInfoSqlHelper);
        return new ImportedObjectV2(exportableEntityInfo, originalId, ImportedObjectV1ToV2Converter.buildProperties(originalId, exportableEntityInfo, legacyImportedObject.getProperties(), entityInfoSqlHelper, hibernateMetadataHelper));
    }

    private static Object extractOriginalIdValue(PrimitiveId idProperty, @Nullable CompositeId compositeId, ExportableEntityInfo entityInfo, EntityInfoSqlHelper entityInfoSqlHelper) {
        if (compositeId != null) {
            LinkedHashMap<String, Object> idValues = new LinkedHashMap<String, Object>();
            List<HibernateField.Type> idSubTypes = entityInfo.getId().getTypes();
            List<String> idPropertyNames = entityInfo.getId().getPropertyNames();
            for (int i = 0; i < idSubTypes.size(); ++i) {
                HibernateField.Type subtype = idSubTypes.get(i);
                String propertyName = idPropertyNames.get(i);
                String value = compositeId.getPropertyValue(propertyName);
                idValues.put(propertyName, entityInfoSqlHelper.convertToDbReadyValue(subtype, value));
            }
            return idValues;
        }
        return entityInfoSqlHelper.convertToDbReadyValue(entityInfo.getId().getType(), idProperty.getValue());
    }

    private static Map<String, Object> buildProperties(Object originalId, ExportableEntityInfo exportableEntityInfo, Collection<ImportedProperty> properties, EntityInfoSqlHelper entityInfoSqlHelper, HibernateMetadataHelper hibernateMetadataHelper) throws ClassNotFoundException {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        for (ImportedProperty property : properties) {
            String propertyName = property.getName();
            HibernateField.Type hibernateType = exportableEntityInfo.getHibernateTypeByFieldName(propertyName);
            if (hibernateType != null) {
                Object dbReadyValue = ImportedObjectV1ToV2Converter.convertPropertyToDbReadyValue(exportableEntityInfo, property, hibernateType, entityInfoSqlHelper, hibernateMetadataHelper);
                if (dbReadyValue == null) continue;
                propertyMap.put(propertyName, dbReadyValue);
                continue;
            }
            log.warn("Unexpected imported property '{}' will be skipped. Entity class '{}', id '{}'.", new Object[]{property, exportableEntityInfo.getEntityClass().getName(), originalId});
        }
        return propertyMap;
    }

    private static Object convertPropertyToDbReadyValue(ExportableEntityInfo exportableEntityInfo, ImportedProperty property, HibernateField.Type hibernateType, EntityInfoSqlHelper entityInfoSqlHelper, HibernateMetadataHelper hibernateMetadataHelper) throws ClassNotFoundException {
        ImportedProperty importedProperty = property;
        Objects.requireNonNull(importedProperty);
        ImportedProperty importedProperty2 = importedProperty;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CollectionProperty.class, PrimitiveProperty.class, ReferenceProperty.class, ContentTypeEnumProperty.class, EnumProperty.class, ComponentProperty.class}, (Object)importedProperty2, n)) {
            case 0: {
                CollectionProperty collectionProperty = (CollectionProperty)importedProperty2;
                return ImportedObjectV1ToV2Converter.convertCollectionToDbReadyValue(collectionProperty, exportableEntityInfo);
            }
            case 1: {
                PrimitiveProperty primitiveProperty = (PrimitiveProperty)importedProperty2;
                return entityInfoSqlHelper.convertToDbReadyValue(hibernateType, primitiveProperty.getValue());
            }
            case 2: {
                ReferenceProperty referenceProperty = (ReferenceProperty)importedProperty2;
                ExportableEntityInfo referencedEntityInfo = hibernateMetadataHelper.getEntityInfoByClass(hibernateType.getReturnedClass());
                HibernateField.Type referencedEntityType = referencedEntityInfo.getId().getType();
                return entityInfoSqlHelper.convertToDbReadyValue(referencedEntityType, referenceProperty.getId().getValue());
            }
            case 3: {
                ContentTypeEnumProperty contentTypeEnumProperty = (ContentTypeEnumProperty)importedProperty2;
                return contentTypeEnumProperty.getEnumValueByRepresentation();
            }
            case 4: {
                EnumProperty enumProperty = (EnumProperty)importedProperty2;
                return ImportedObjectV1ToV2Converter.convertEnumToToDbValue(hibernateType, enumProperty.getValue());
            }
            case 5: {
                ComponentProperty componentProperty = (ComponentProperty)importedProperty2;
                if (!componentProperty.getName().equals("credential")) {
                    throw new IllegalArgumentException(String.format("Unknown component type for component %s", componentProperty.getName()));
                }
                return componentProperty.getPropertyStringValue("credential");
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected property of class %s. Property name %s", property.getClass().getName(), property.getName()));
    }

    private static Object convertEnumToToDbValue(HibernateField.Type hibernateType, String value) {
        int sqlType = hibernateType.getSqlType();
        if (sqlType == 4 || sqlType == -5) {
            return ImportedObjectV1ToV2Converter.getEnumId(hibernateType.getReturnedClass(), value);
        }
        return value;
    }

    private static int getEnumId(Class<?> returnedClass, String value) {
        if (returnedClass.equals(Severity.class)) {
            if (StringUtils.isNumeric((CharSequence)value)) {
                return Integer.parseInt(value);
            }
            return Severity.valueOf((String)value).getId();
        }
        throw new IllegalArgumentException("Unsupported enum: " + String.valueOf(returnedClass));
    }

    private static Object convertCollectionToDbReadyValue(CollectionProperty property, ExportableEntityInfo exportableEntityInfo) {
        return switch (property.getName()) {
            case "contentProperties", "directoryMappings", "credentialRecords" -> ImportedObjectV1ToV2Converter.convertListOfReferences(property);
            case "allowedOperations" -> ImportedObjectV1ToV2Converter.convertSetOfEnums(property);
            case "attributes" -> {
                if (ApplicationImpl.class.equals(exportableEntityInfo.getEntityClass()) || DirectoryImpl.class.equals(exportableEntityInfo.getEntityClass())) {
                    yield ImportedObjectV1ToV2Converter.convertMapOfAttributes(property);
                }
                yield null;
            }
            default -> null;
        };
    }

    private static Object convertListOfReferences(CollectionProperty property) {
        return property.getValues().stream().filter(ReferenceProperty.class::isInstance).map(value -> Long.parseLong(((ReferenceProperty)value).getId().getValue())).collect(Collectors.toList());
    }

    private static Object convertSetOfEnums(CollectionProperty property) {
        return property.getValues().stream().filter(EnumProperty.class::isInstance).map(value -> ((EnumProperty)value).getValue()).collect(Collectors.toSet());
    }

    private static Object convertMapOfAttributes(CollectionProperty property) {
        return property.getValues().stream().filter(PrimitiveProperty.class::isInstance).map(PrimitiveProperty.class::cast).collect(Collectors.toMap(ImportedProperty::getName, PrimitiveProperty::getValue));
    }

    @Override
    public Optional<ImportedObjectV2> apply(ImportedObject importedObject) {
        Optional<Class<?>> optionalEntityClass = this.classExistenceValidator.getEntityClass(importedObject);
        if (optionalEntityClass.isEmpty()) {
            return Optional.empty();
        }
        Class<?> entityClass = optionalEntityClass.get();
        if (!this.filters.stream().allMatch(filter -> filter.test(importedObject, entityClass))) {
            return Optional.empty();
        }
        return this.convert(importedObject, entityClass).flatMap(this::applyAllPreprocessors);
    }

    private Optional<ImportedObjectV2> applyAllPreprocessors(ImportedObjectV2 importedObjectV2) {
        for (ImportedObjectPreprocessor preprocessor : this.preprocessors) {
            Optional<ImportedObjectV2> processedObject = preprocessor.apply(importedObjectV2);
            if (processedObject.isEmpty()) {
                return Optional.empty();
            }
            importedObjectV2 = processedObject.get();
        }
        return Optional.of(importedObjectV2);
    }

    private Optional<ImportedObjectV2> convert(ImportedObject importedObject, Class<?> entityClass) {
        ExportableEntityInfo exportableEntityInfo = this.hibernateMetadataHelper.getEntityInfoByClass(entityClass);
        try {
            return Optional.of(ImportedObjectV1ToV2Converter.fromLegacyImportedObject(importedObject, exportableEntityInfo, this.entityInfoSqlHelper, this.hibernateMetadataHelper));
        }
        catch (ClassNotFoundException e) {
            log.error("fromLegacyImportedObject failed, the object will be skipped: {}", (Object)importedObject, (Object)e);
            return Optional.empty();
        }
    }
}

