/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.preprocessing;

import com.atlassian.confluence.core.PersistentDecorator;
import com.atlassian.confluence.impl.backuprestore.restore.domain.ImportedObjectV2;
import com.atlassian.confluence.impl.backuprestore.restore.preprocessing.ImportedObjectPreprocessor;
import com.atlassian.confluence.upgrade.PersistentDecoratorUpgradeHelper;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class PersistentDecoratorUpgradePreprocessor
implements ImportedObjectPreprocessor {
    private static final String PROPERTY_BODY_KEY = "body";
    private static final String PROPERTY_NAME_KEY = "name";

    @Override
    public Optional<ImportedObjectV2> apply(ImportedObjectV2 importedObject) {
        if (!PersistentDecorator.class.equals(importedObject.getEntityClass())) {
            return Optional.of(importedObject);
        }
        String decoratorBody = (String)importedObject.getPropertyValueMap().get(PROPERTY_BODY_KEY);
        String decoratorName = (String)importedObject.getPropertyValueMap().get(PROPERTY_NAME_KEY);
        if (StringUtils.isEmpty((CharSequence)decoratorName) || StringUtils.isEmpty((CharSequence)decoratorBody)) {
            return Optional.of(importedObject);
        }
        String newBody = PersistentDecoratorUpgradeHelper.replaceLangMacroInDecorator(decoratorBody, decoratorName);
        ImportedObjectV2 migratedObject = importedObject.overridePropertyValues(PROPERTY_BODY_KEY, Collections.singletonMap(PROPERTY_BODY_KEY, newBody));
        return Optional.of(migratedObject);
    }
}

