/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.preprocessing;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.impl.backuprestore.restore.domain.ImportedObjectV2;
import com.atlassian.confluence.impl.backuprestore.restore.preprocessing.ImportedObjectPreprocessor;
import com.atlassian.confluence.impl.user.crowd.serviceaccount.ServiceAccountUserImpl;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class UserMappingUpgradePreprocessor
implements ImportedObjectPreprocessor {
    @VisibleForTesting
    protected static final String USER_MAPPING_ENTITY_TYPE_FIELD = "entity_type";

    @Override
    public Optional<ImportedObjectV2> apply(ImportedObjectV2 importedObject) {
        if (!ConfluenceUserImpl.class.equals(importedObject.getEntityClass()) && !ServiceAccountUserImpl.class.equals(importedObject.getEntityClass())) {
            return Optional.of(importedObject);
        }
        String entityType = (String)importedObject.getFieldValue(USER_MAPPING_ENTITY_TYPE_FIELD);
        if (StringUtils.isEmpty((CharSequence)entityType)) {
            ImportedObjectV2 migratedObject = ServiceAccountUserImpl.class.equals(importedObject.getEntityClass()) ? importedObject.overridePropertyValues(importedObject.getId(), Collections.singletonMap(USER_MAPPING_ENTITY_TYPE_FIELD, "SA")) : importedObject.overridePropertyValues(importedObject.getId(), Collections.singletonMap(USER_MAPPING_ENTITY_TYPE_FIELD, "USER"));
            return Optional.of(migratedObject);
        }
        return Optional.of(importedObject);
    }
}

