/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.searchindexer;

import com.atlassian.confluence.api.model.backuprestore.JobScope;
import com.atlassian.confluence.impl.backuprestore.ParallelTasksExecutor;
import com.atlassian.confluence.impl.backuprestore.restore.searchindexer.OnRestoreSearchIndexer;
import com.atlassian.confluence.impl.backuprestore.restore.searchindexer.OnRestoreSiteSearchIndexer;
import com.atlassian.confluence.impl.backuprestore.restore.searchindexer.OnRestoreSpaceSearchIndexer;
import com.atlassian.confluence.impl.backuprestore.restore.searchindexer.SearchIndexerAdapter;
import com.atlassian.confluence.impl.backuprestore.restore.stash.ImportedObjectsStashFactory;
import com.atlassian.confluence.impl.journal.JournalStateStore;

public class OnRestoreSearchIndexerFactory {
    private final SearchIndexerAdapter searchIndexerAdapter;
    private final ImportedObjectsStashFactory importedObjectsStashFactory;
    private final JournalStateStore journalStateStore;
    private final JournalStateStore bandanaJournalStateStore;

    public OnRestoreSearchIndexerFactory(SearchIndexerAdapter searchIndexerAdapter, ImportedObjectsStashFactory importedObjectsStashFactory, JournalStateStore journalStateStore, JournalStateStore bandanaJournalStateStore) {
        this.searchIndexerAdapter = searchIndexerAdapter;
        this.importedObjectsStashFactory = importedObjectsStashFactory;
        this.journalStateStore = journalStateStore;
        this.bandanaJournalStateStore = bandanaJournalStateStore;
    }

    public OnRestoreSearchIndexer createOnRestoreSearchIndexer(JobScope jobScope, ParallelTasksExecutor parallelTasksExecutor) {
        return switch (jobScope) {
            default -> throw new MatchException(null, null);
            case JobScope.SITE -> new OnRestoreSiteSearchIndexer(this.searchIndexerAdapter, this.journalStateStore, this.bandanaJournalStateStore);
            case JobScope.SPACE -> new OnRestoreSpaceSearchIndexer(this.searchIndexerAdapter, this.importedObjectsStashFactory, parallelTasksExecutor);
        };
    }
}

