/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.stash;

import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateMetadataHelper;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StashObjectInputStream
extends ObjectInputStream {
    private static Logger log = LoggerFactory.getLogger(StashObjectInputStream.class);
    private HibernateMetadataHelper hibernateMetadataHelper;
    private final Set<Class<?>> ALLOWED_CLASSES;
    private static final String UNMODIFIABLE_MAP_CLASS_NAME = "java.util.Collections$UnmodifiableMap";
    static final String ADDITIONAL_ALLOWED_CLASSES_PROPERTY = "stash.deserialize.classes.allowlist";

    public StashObjectInputStream(InputStream in, HibernateMetadataHelper hibernateMetadataHelper, Set<Class<?>> allowedClasses) throws IOException {
        super(in);
        this.hibernateMetadataHelper = hibernateMetadataHelper;
        this.ALLOWED_CLASSES = allowedClasses;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        if (!this.isClassNameAllowedForDeserialization(className)) {
            throw new InvalidClassException("Unauthorized deserialization attempt", className);
        }
        return super.resolveClass(desc);
    }

    private static Set<Class<?>> getAdditionalAllowedClasses() {
        HashSet additionalClasses = new HashSet();
        String additionalClassesProperty = System.getProperty(ADDITIONAL_ALLOWED_CLASSES_PROPERTY);
        if (!StringUtils.isBlank((CharSequence)additionalClassesProperty)) {
            String[] classNames;
            for (String className : classNames = additionalClassesProperty.split(",")) {
                try {
                    Class<?> clazz = Class.forName(className.trim());
                    additionalClasses.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    log.warn("Class not found for additional allowed class: {}", (Object)className, (Object)e);
                }
            }
        }
        return additionalClasses;
    }

    private boolean isClassNameAllowedForDeserialization(String className) {
        Sets.SetView result = Sets.union(this.ALLOWED_CLASSES, StashObjectInputStream.getAdditionalAllowedClasses());
        Set allowedClassNames = result.stream().map(Class::getName).collect(Collectors.toSet());
        allowedClassNames.add(UNMODIFIABLE_MAP_CLASS_NAME);
        return allowedClassNames.contains(className) || this.isAllowedEntityClass(className);
    }

    private boolean isAllowedEntityClass(String className) {
        return this.hibernateMetadataHelper.getEntityInfoByClassName(className) != null;
    }
}

