/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.stash;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.AbstractVersionedEntityObject;
import com.atlassian.confluence.core.AnnotatedEntityObject;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.dmz.relations.dao.RelationEntity;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateMetadataHelper;
import com.atlassian.confluence.impl.backuprestore.restore.domain.ImportedObjectV2;
import com.atlassian.confluence.impl.backuprestore.restore.stash.StashObjectInputStream;
import com.atlassian.confluence.links.AbstractLink;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.InternalEntity;
import com.atlassian.crowd.model.InternalEntityAttribute;
import com.atlassian.sal.api.user.UserKey;
import com.opensymphony.module.propertyset.hibernate.PropertySetItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class StashObjectsSerialiser {
    private final Supplier<HibernateMetadataHelper> hibernateMetadataHelper;
    private final Set<Class<?>> allowedClasses;
    private final Boolean stashDeserializeAllowlistEnabled;
    static final String STASH_DESERIALIZE_ALLOWLIST_ENABLED_PROPERTY = "stash.deserialize.allowlist.enabled";
    private static final Set<Class<?>> ALLOWED_CLASSES = Set.of(ImportedObjectV2.class, AbstractLabelableEntityObject.class, AbstractVersionedEntityObject.class, AbstractLink.class, ConfluenceEntityObject.class, InternalDirectoryEntity.class, InternalEntity.class, RelationEntity.class, InternalEntityAttribute.class, PropertySetItem.class, UserKey.class, EntityObject.class, AnnotatedEntityObject.class, Number.class, Long.class, HashSet.class, LinkedHashMap.class, Map.class, HashMap.class, Integer.class, Double.class, Timestamp.class, Date.class, ArrayList.class, Boolean.class, Enum.class, ContentTypeEnum.class);

    public StashObjectsSerialiser() {
        this.hibernateMetadataHelper = MemoizingComponentReference.containerComponent("hibernateMetadataHelper");
        this.allowedClasses = ALLOWED_CLASSES;
        this.stashDeserializeAllowlistEnabled = Boolean.TRUE;
    }

    @VisibleForTesting
    public StashObjectsSerialiser(HibernateMetadataHelper hibernateMetadataHelper) {
        this.hibernateMetadataHelper = () -> hibernateMetadataHelper;
        this.allowedClasses = ALLOWED_CLASSES;
        this.stashDeserializeAllowlistEnabled = System.getProperty(STASH_DESERIALIZE_ALLOWLIST_ENABLED_PROPERTY) == null || Boolean.getBoolean(STASH_DESERIALIZE_ALLOWLIST_ENABLED_PROPERTY);
    }

    @VisibleForTesting
    public StashObjectsSerialiser(HibernateMetadataHelper hibernateMetadataHelper, Set<Class<?>> allowedClasses) {
        this.hibernateMetadataHelper = () -> hibernateMetadataHelper;
        this.allowedClasses = allowedClasses;
        this.stashDeserializeAllowlistEnabled = System.getProperty(STASH_DESERIALIZE_ALLOWLIST_ENABLED_PROPERTY) == null || Boolean.getBoolean(STASH_DESERIALIZE_ALLOWLIST_ENABLED_PROPERTY);
    }

    public byte[] serialise(ImportedObjectV2 objectV2) throws IOException {
        try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayStream);){
                outputStream.writeObject(objectV2);
                outputStream.flush();
                byArray = byteArrayStream.toByteArray();
            }
            return byArray;
        }
    }

    public ImportedObjectV2 deserialise(byte[] byteArray) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);){
            ObjectInputStream objectInputStream = this.stashDeserializeAllowlistEnabled != false ? new StashObjectInputStream(byteArrayInputStream, this.hibernateMetadataHelper.get(), this.allowedClasses) : new ObjectInputStream(byteArrayInputStream);
            ImportedObjectV2 importedObjectV2 = (ImportedObjectV2)objectInputStream.readObject();
            ExportableEntityInfo exportableEntityInfo = this.hibernateMetadataHelper.get().getEntityInfoByClass(importedObjectV2.getEntityClass());
            ImportedObjectV2 importedObjectV22 = new ImportedObjectV2(exportableEntityInfo, importedObjectV2.getId(), importedObjectV2.getPropertyValueMap());
            return importedObjectV22;
        }
    }
}

