/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.taskrunners;

import com.atlassian.confluence.backuprestore.exception.BackupRestoreException;
import com.atlassian.confluence.dmz.pages.TrashManagerInternal;
import com.atlassian.confluence.impl.backuprestore.restore.container.BackupProperties;
import com.atlassian.confluence.impl.backuprestore.restore.taskrunners.PostSiteImportUpgrader;
import com.atlassian.confluence.impl.core.persistence.hibernate.schema.LabelUniqueIndexHelper;
import com.atlassian.confluence.internal.index.status.ReIndexJobPersister;
import com.atlassian.confluence.internal.spaces.persistence.SpaceDaoInternal;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.upgrade.BuildNumber;
import com.atlassian.confluence.upgrade.upgradetask.BandanaToPluginSettingsUpgradeTask;
import com.atlassian.confluence.util.FilesystemUtils;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.event.api.EventPublisher;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostImportTaskRunner {
    private static final Logger log = LoggerFactory.getLogger(PostImportTaskRunner.class);
    private final SpacePermissionManager spacePermissionManager;
    private final EventPublisher eventPublisher;
    private final ReIndexJobPersister reIndexJobPersister;
    private final TrashManagerInternal trashManagerInternal;
    private final PostSiteImportUpgrader postSiteImportUpgrader;
    private final SpaceDaoInternal spaceDaoInternal;
    private final LabelUniqueIndexHelper labelUniqueIndexHelper;
    private final BandanaToPluginSettingsUpgradeTask bandanaMigrationTask;

    public PostImportTaskRunner(SpacePermissionManager spacePermissionManager, EventPublisher eventPublisher, ReIndexJobPersister reIndexJobPersister, TrashManagerInternal trashManagerInternal, PostSiteImportUpgrader postSiteImportUpgrader, SpaceDaoInternal spaceDaoInternal, LabelUniqueIndexHelper labelUniqueIndexHelper, BandanaToPluginSettingsUpgradeTask bandanaMigrationTask) {
        this.spacePermissionManager = spacePermissionManager;
        this.eventPublisher = eventPublisher;
        this.reIndexJobPersister = reIndexJobPersister;
        this.trashManagerInternal = trashManagerInternal;
        this.postSiteImportUpgrader = postSiteImportUpgrader;
        this.spaceDaoInternal = spaceDaoInternal;
        this.labelUniqueIndexHelper = labelUniqueIndexHelper;
        this.bandanaMigrationTask = bandanaMigrationTask;
    }

    public void runUpgradeTasks(BackupProperties backupProperties) throws BackupRestoreException {
        this.postSiteImportUpgrader.runUpgradeTasks(backupProperties);
    }

    public void runCacheFlushingPostImportTask(String workingFile) {
        String checksum;
        log.debug("Flushing space permission caches");
        this.spacePermissionManager.flushCaches();
        log.debug("Publishing restore-finished event to Embedded Crowd components");
        try {
            checksum = FilesystemUtils.getFileChecksum(workingFile);
        }
        catch (Exception e) {
            log.debug("Error while calculating checksum for file at path {} ", (Object)workingFile, (Object)e);
            checksum = "Unknown checksum";
        }
        this.eventPublisher.publish((Object)new XMLRestoreFinishedEvent((Object)this, workingFile, checksum));
    }

    public void runClearReIndexJobPostImportTask() {
        log.debug("Deleting re-index history of previous instance");
        this.reIndexJobPersister.clear();
    }

    public void evictSpacesFromCache(Collection<String> spaceKeys) {
        spaceKeys.forEach(this.spaceDaoInternal::removeSpaceFromCache);
    }

    public void runTrashDatePostImportTaskForSpaces(Collection<String> spaceKeys) {
        Instant importTime = Instant.now();
        spaceKeys.forEach(spaceKey -> {
            log.debug("Setting {} as default trash date for space {}", (Object)importTime, spaceKey);
            this.trashManagerInternal.migrateTrashDate((String)spaceKey, importTime);
        });
    }

    public void runTrashDatePostImportTaskForSite() {
        Instant importTime = Instant.now();
        log.debug("Setting {} as default trash date", (Object)importTime);
        this.trashManagerInternal.migrateTrashDate(importTime);
    }

    public void runLabelCleanUpAndCreateIndexPostImportTask(BackupProperties backupProperties) {
        BuildNumber importBuildNumber = Objects.requireNonNullElse(backupProperties.getCreatedByBuildNumber(), backupProperties.getBuildNumber());
        if (Integer.parseInt(importBuildNumber.toString()) < Integer.parseInt("9109")) {
            log.debug("Cleaning up duplicated labels");
            this.labelUniqueIndexHelper.cleanUpDuplicatedLabels();
        }
        log.debug("Creating virtual column based on OWNER column for LABEL table and adding a unique index for it");
        this.labelUniqueIndexHelper.createVirtualColumnAndUniqueIndex();
    }

    public void migrateBandanaDataToPluginSettings(Collection<String> spaceKeys) throws BackupRestoreException {
        try {
            spaceKeys.forEach(this.bandanaMigrationTask::migrateForContext);
        }
        catch (Exception e) {
            throw new BackupRestoreException(e);
        }
    }
}

