/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.restore.taskrunners;

import com.atlassian.confluence.backuprestore.BackupRestoreSettings;
import com.atlassian.confluence.backuprestore.exception.BackupRestoreException;
import com.atlassian.confluence.impl.backuprestore.restore.container.BackupProperties;
import com.atlassian.confluence.impl.backuprestore.restore.taskrunners.ImportTaskRunner;
import com.atlassian.confluence.impl.backuprestore.restore.taskrunners.PostImportTaskRunner;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceImportTaskRunner
implements ImportTaskRunner {
    private static final Logger log = LoggerFactory.getLogger(SpaceImportTaskRunner.class);
    private final PostImportTaskRunner postImportTaskRunner;

    public SpaceImportTaskRunner(PostImportTaskRunner postImportTaskRunner) {
        this.postImportTaskRunner = postImportTaskRunner;
    }

    @Override
    public void runPostImportTasks(BackupRestoreSettings settings, BackupProperties backupProperties) throws BackupRestoreException {
        String restoredFileName = settings.getFileName();
        StopWatch stopWatch = StopWatch.createStarted();
        this.postImportTaskRunner.evictSpacesFromCache(backupProperties.getSpaceKeys());
        this.postImportTaskRunner.runCacheFlushingPostImportTask(restoredFileName);
        this.postImportTaskRunner.runClearReIndexJobPostImportTask();
        this.postImportTaskRunner.runTrashDatePostImportTaskForSpaces(backupProperties.getSpaceKeys());
        this.postImportTaskRunner.migrateBandanaDataToPluginSettings(backupProperties.getSpaceKeys());
        log.debug("Post import tasks duration: {}", (Object)stopWatch);
    }
}

