/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.scheduledjob;

import com.atlassian.confluence.backuprestore.BackupRestoreJob;
import com.atlassian.confluence.backuprestore.BackupRestoreJobsSearchFilter;
import com.atlassian.confluence.impl.backuprestore.BackupRestoreFilesystemManager;
import com.atlassian.confluence.impl.backuprestore.dao.BackupRestoreJobDao;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupRestoreNotExistingFileMarkerScheduledJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(BackupRestoreNotExistingFileMarkerScheduledJob.class);
    private final BackupRestoreJobDao backupRestoreJobDao;
    private final BackupRestoreFilesystemManager backupRestoreFilesystemManager;

    public BackupRestoreNotExistingFileMarkerScheduledJob(BackupRestoreJobDao backupRestoreJobDao, BackupRestoreFilesystemManager backupRestoreFilesystemManager) {
        this.backupRestoreJobDao = backupRestoreJobDao;
        this.backupRestoreFilesystemManager = backupRestoreFilesystemManager;
    }

    public @Nullable JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        BackupRestoreJobsSearchFilter onlyExistingBackupsFilter = new BackupRestoreJobsSearchFilter.Builder().setFileExists(true).build();
        this.backupRestoreJobDao.findJobs(onlyExistingBackupsFilter).forEach(job -> {
            if (!this.backupRestoreFilesystemManager.exists(job.getJobScope(), job.getFileName())) {
                log.info("File {} does not exist, Set in job {} fileExists=false", (Object)(job.getJobScope().toString() + "#" + job.getFileName()), (Object)job.getId());
                job.setFileExists(false);
                this.backupRestoreJobDao.update((BackupRestoreJob)job);
            }
        });
        return JobRunnerResponse.success();
    }
}

