/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.userkeyupdate;

import com.atlassian.confluence.impl.backuprestore.userkeyupdate.ContentUserKeyUpdater;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.utils.StringUtils;

public class PatternBasedContentUserKeyUpdater
implements ContentUserKeyUpdater<String> {
    private static final Pattern userKeyPatternMatcher = Pattern.compile("[a-zA-Z0-9_:-]+");

    @Override
    public String updateUserKeyInContent(String oldBodyContent, Map<String, String> oldUserKeyToNewUserKeyMap) {
        if (StringUtils.isEmpty((CharSequence)oldBodyContent) || oldUserKeyToNewUserKeyMap == null || oldUserKeyToNewUserKeyMap.isEmpty()) {
            return oldBodyContent;
        }
        StringBuilder populatedTemplate = new StringBuilder();
        Matcher matcher = userKeyPatternMatcher.matcher(oldBodyContent);
        int fromIndex = 0;
        while (matcher.find(fromIndex)) {
            int startIdx = matcher.start();
            if (fromIndex < startIdx) {
                populatedTemplate.append(oldBodyContent, fromIndex, startIdx);
            }
            String userKeyEntry = matcher.group();
            populatedTemplate.append(oldUserKeyToNewUserKeyMap.getOrDefault(userKeyEntry, userKeyEntry));
            fromIndex = matcher.end();
        }
        if (fromIndex < oldBodyContent.length()) {
            populatedTemplate.append(oldBodyContent, fromIndex, oldBodyContent.length());
        }
        return populatedTemplate.toString();
    }
}

