/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.bandana;

import com.atlassian.annotations.nullability.ReturnValuesAreNullableByDefault;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaRecord;
import com.atlassian.confluence.setup.bandana.persistence.dao.ConfluenceBandanaRecordDao;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.dao.support.DataAccessUtils;

@ReturnValuesAreNullableByDefault
public class HibernateConfluenceBandanaRecordDao
implements ConfluenceBandanaRecordDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateConfluenceBandanaRecordDao.class);
    private final SessionFactory sessionFactory;

    public HibernateConfluenceBandanaRecordDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void saveOrUpdate(ConfluenceBandanaRecord record) {
        ConfluenceBandanaRecord persistent = this.getPersistent(record);
        if (persistent == null) {
            if (record.getId() != 0L) {
                log.error("Attempted to save bandana record with ID already set. CONF-8785!");
                throw new IllegalStateException("Attempted to save a Bandana record that already has an ID. CONF-8785");
            }
            this.sessionFactory.getCurrentSession().save((Object)record);
        } else {
            BeanUtils.copyProperties((Object)record, (Object)persistent, (String[])new String[]{"id"});
            this.sessionFactory.getCurrentSession().update((Object)persistent);
        }
    }

    public ConfluenceBandanaRecord getRecord(String context, String key) {
        List results = this.sessionFactory.getCurrentSession().createNamedQuery("confluence.bandanarecord_findByContextAndKey", ConfluenceBandanaRecord.class).setParameter("context", (Object)context).setParameter("key", (Object)key).list();
        return results.isEmpty() ? null : (ConfluenceBandanaRecord)results.getFirst();
    }

    public void remove(ConfluenceBandanaRecord record) {
        this.sessionFactory.getCurrentSession().createQuery("from ConfluenceBandanaRecord cbr where cbr.context = :context and cbr.key = :key", ConfluenceBandanaRecord.class).setParameter("context", (Object)record.getContext()).setParameter("key", (Object)record.getKey()).list().forEach(arg_0 -> ((Session)this.sessionFactory.getCurrentSession()).delete(arg_0));
    }

    private ConfluenceBandanaRecord getPersistent(ConfluenceBandanaRecord record) {
        return this.getRecord(record.getContext(), record.getKey());
    }

    public void removeAllInContext(String context) {
        this.sessionFactory.getCurrentSession().createQuery("from ConfluenceBandanaRecord cbr where cbr.context = :context", ConfluenceBandanaRecord.class).setParameter("context", (Object)context).list().forEach(arg_0 -> ((Session)this.sessionFactory.getCurrentSession()).delete(arg_0));
    }

    public Collection<ConfluenceBandanaRecord> findForContext(String context) {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.bandanarecord_findByContext", ConfluenceBandanaRecord.class).setParameter("context", (Object)context).list();
    }

    public Iterable<String> findKeysForContext(String context) {
        return this.sessionFactory.getCurrentSession().createQuery("select cbr.key from ConfluenceBandanaRecord cbr where cbr.context = :context", String.class).setParameter("context", (Object)context).list();
    }

    public long countWithKey(String key) {
        List results = this.sessionFactory.getCurrentSession().createQuery("select count(*) from ConfluenceBandanaRecord cbr where cbr.key = :key", Number.class).setParameter("key", (Object)key).list();
        try {
            return DataAccessUtils.longResult((Collection)results);
        }
        catch (IncorrectResultSizeDataAccessException | TypeMismatchDataAccessException ex) {
            log.error("Could not count record in Bandana table with key {}", (Object)key, (Object)ex);
            return 0L;
        }
    }
}

