/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache;

import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cache.CacheConfigManager;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.impl.cache.ConfluenceCacheManager;
import com.atlassian.confluence.impl.cache.LocalCacheImplementation;
import com.atlassian.confluence.impl.cache.PluginSafeCacheManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class CacheManagerContextConfig {
    CacheManagerContextConfig() {
    }

    @Bean
    static CacheManager localCacheManager(@Qualifier(value="ehCacheManager") CacheManager ehcache, @Qualifier(value="caffeineCacheManager") CacheManager caffeine) {
        return switch (LocalCacheImplementation.get()) {
            default -> throw new MatchException(null, null);
            case LocalCacheImplementation.EHCACHE -> ehcache;
            case LocalCacheImplementation.CAFFEINE -> caffeine;
        };
    }

    @Bean
    static CacheManager cacheManager(ClusterManager clusterManager, EventPublisher eventPublisher, @Qualifier(value="localCacheManager") CacheManager local, @Qualifier(value="confluenceNutclusterCacheManager") CacheManager clustered) {
        return new ConfluenceCacheManager(clusterManager.isClustered() ? clustered : local, eventPublisher);
    }

    @Bean
    @AvailableToPlugins(interfaces={CacheManager.class})
    static CacheManager pluginSafeCacheManager(@Qualifier(value="cacheManager") CacheManager cacheManager) {
        return new PluginSafeCacheManager(cacheManager);
    }

    @Bean
    @AvailableToPlugins(interfaces={CacheConfigManager.class})
    static CacheConfigManager cacheConfigManager(ClusterManager clusterManager, @Qualifier(value="nutclusterCacheConfigManager") CacheConfigManager clustered, @Qualifier(value="ehCacheConfigManager") CacheConfigManager ehCache, @Qualifier(value="caffeineCacheManager") CacheConfigManager caffeine) {
        if (clusterManager.isClustered()) {
            return clustered;
        }
        return switch (LocalCacheImplementation.get()) {
            default -> throw new MatchException(null, null);
            case LocalCacheImplementation.EHCACHE -> ehCache;
            case LocalCacheImplementation.CAFFEINE -> caffeine;
        };
    }
}

