/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.confluence.impl.cache.ClusterCacheFlushEvent;
import com.atlassian.confluence.impl.cache.DelegatingCacheManager;
import com.atlassian.event.api.EventPublisher;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class ConfluenceCacheManager
extends DelegatingCacheManager {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceCacheManager.class);
    private final CacheManager delegate;
    private final EventPublisher eventPublisher;

    public ConfluenceCacheManager(CacheManager delegate, EventPublisher eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    @Override
    protected CacheManager getDelegate() {
        return this.delegate;
    }

    @Override
    public void flushCaches() {
        log.warn("Flushing all caches");
        super.flushCaches();
        this.eventPublisher.publish((Object)new ClusterCacheFlushEvent(this));
    }

    @Override
    public <V> @NonNull CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier, CacheSettings settings) {
        return this.getDelegate().getCachedReference(owningClass, name, supplier, ConfluenceCacheManager.overrideCachedReferenceSettings(settings));
    }

    @Override
    public <V> @NonNull CachedReference<V> getCachedReference(String name, Supplier<V> supplier, CacheSettings settings) {
        return this.getDelegate().getCachedReference(name, supplier, ConfluenceCacheManager.overrideCachedReferenceSettings(settings));
    }

    private static CacheSettings overrideCachedReferenceSettings(CacheSettings settings) {
        return settings.override(new CacheSettingsBuilder().maxEntries(1).build());
    }
}

