/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.tx;

import com.atlassian.confluence.impl.cache.tx.Deferred;
import com.atlassian.confluence.impl.cache.tx.DeferredCachedReference;
import com.atlassian.confluence.impl.cache.tx.DeferredOperationsCache;
import com.atlassian.confluence.impl.cache.tx.TransactionalCacheFactory;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionalCacheFactoryCleaner {
    private static final Logger log = LoggerFactory.getLogger(TransactionalCacheFactoryCleaner.class);
    private static final Function<Deferred, String> TO_NAME = Deferred::getName;
    private static final Predicate<Deferred> IS_CACHE = deferred -> deferred instanceof DeferredOperationsCache;
    private static final Predicate<Deferred> IS_CACHED_REFERENCE = deferred -> deferred instanceof DeferredCachedReference;
    private static final Supplier<TransactionalCacheFactory> transactionalCacheFactoryRef = MemoizingComponentReference.containerComponent("transactionalCacheFactory");

    TransactionalCacheFactoryCleaner() {
    }

    public static Cleaner cleaner(String identifier) {
        if (ContainerManager.isContainerSetup()) {
            TreeSet cachedReferenceNames;
            Iterable<Deferred> deferreds = transactionalCacheFactoryRef.get().getDeferreds();
            TreeSet cacheNames = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)Iterables.filter(deferreds, IS_CACHE), TO_NAME));
            if (!cacheNames.isEmpty()) {
                log.warn("Found some transactional caches still bound to thread following execution of [{}] - {}", (Object)identifier, (Object)cacheNames);
            }
            if (!(cachedReferenceNames = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)Iterables.filter(deferreds, IS_CACHED_REFERENCE), TO_NAME))).isEmpty()) {
                log.warn("Found some transactional cached references still bound to thread following execution of [{}] - {}", (Object)identifier, (Object)cachedReferenceNames);
            }
        }
        return () -> {
            if (ContainerManager.isContainerSetup()) {
                TreeSet cachedReferenceNames;
                Iterable<Deferred> deferreds = transactionalCacheFactoryRef.get().forceUnbindCaches();
                TreeSet cacheNames = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)Iterables.filter(deferreds, IS_CACHE), TO_NAME));
                if (!cacheNames.isEmpty()) {
                    log.warn("Forcibly unbound thread-local transactional caches prior to request execution: {}", (Object)cacheNames);
                }
                if (!(cachedReferenceNames = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)Iterables.filter(deferreds, IS_CACHED_REFERENCE), TO_NAME))).isEmpty()) {
                    log.warn("Forcibly unbound thread-local transactional cached references prior to request execution: {}", (Object)cachedReferenceNames);
                }
            }
        };
    }

    public static interface Cleaner
    extends AutoCloseable {
        @Override
        public void close();
    }
}

