/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cluster.event;

import com.atlassian.confluence.cluster.ClusterConfigurationAccessor;
import com.atlassian.confluence.impl.cluster.event.ClusterEventService;
import com.atlassian.confluence.impl.cluster.event.PendingAcks;
import com.atlassian.confluence.impl.cluster.event.TopicEvent;
import com.atlassian.confluence.impl.cluster.event.TopicEventCluster;
import com.atlassian.event.api.EventPublisher;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TopicEventPublisher<E extends TopicEvent, N>
implements ClusterEventService {
    private static final Logger log = LoggerFactory.getLogger(TopicEventPublisher.class);
    private final ClusterConfigurationAccessor configurationAccessor;
    private final Consumer<Object> localEventConsumer;
    private final TopicEventCluster<E, N> cluster;
    private final PendingAcks<N> pendingAcks;

    public static <E extends TopicEvent, N> TopicEventPublisher<E, N> create(ClusterConfigurationAccessor configurationAccessor, EventPublisher eventPublisher, TopicEventCluster<E, N> cluster) {
        return new TopicEventPublisher<E, N>(configurationAccessor, arg_0 -> ((EventPublisher)eventPublisher).publish(arg_0), cluster, new PendingAcks<N>(cluster));
    }

    TopicEventPublisher(ClusterConfigurationAccessor configurationAccessor, Consumer<Object> localEventConsumer, TopicEventCluster<E, N> cluster, PendingAcks<N> pendingAcks) {
        this.configurationAccessor = Objects.requireNonNull(configurationAccessor);
        this.localEventConsumer = Objects.requireNonNull(localEventConsumer);
        this.cluster = Objects.requireNonNull(cluster);
        this.pendingAcks = Objects.requireNonNull(pendingAcks);
    }

    @Override
    public ListenableFuture<?> publishEventToCluster(Object event) {
        TopicEvent topicEvent = (TopicEvent)this.cluster.wrapEvent(event);
        ListenableFuture<?> future = this.pendingAcks.addPendingAcks(topicEvent.getId());
        future.addListener(() -> log.debug("Cluster processing of {} has completed", (Object)topicEvent), MoreExecutors.directExecutor());
        log.debug("Publishing {} to Nutcluster topic", (Object)topicEvent);
        this.cluster.publishEvent(topicEvent);
        return future;
    }

    @PreDestroy
    void clearAllPendingAcks() {
        log.debug("Clearing all pending acks");
        this.pendingAcks.removeAll();
    }

    @PostConstruct
    void registerListeners() {
        if (this.configurationAccessor.isClustered()) {
            this.cluster.initialise(this::onEvent, this::onAck, this::onClusterMemberRemoved);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.configurationAccessor.isClustered();
    }

    void onClusterMemberRemoved(N node) {
        log.debug("{} removed from cluster, clearing all corresponding pending acks", node);
        this.pendingAcks.clearPendingAcks(node);
    }

    void onEvent(N clusterNode, E incomingEvent) {
        log.debug("Locally forwarding {} from {}", incomingEvent, clusterNode);
        this.localEventConsumer.accept(incomingEvent.getPayload());
        log.debug("Sending ack for {} to Nutcluster topic", incomingEvent);
        this.cluster.publishAck(incomingEvent.getId());
    }

    void onAck(N clusterNode, UUID eventId) {
        log.debug("{} acked event {}", clusterNode, (Object)eventId);
        this.pendingAcks.ackReceived(eventId, clusterNode);
    }
}

