/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cluster.lock;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLockExecutionService {
    private static final Logger log = LoggerFactory.getLogger(ClusterLockExecutionService.class);
    private final ClusterLockService clusterLockService;

    public ClusterLockExecutionService(ClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWithLock(String lockName, String messagePrefix, Runnable runnable) {
        ClusterLock lock = this.clusterLockService.getLockForName(lockName);
        if (lock == null || !lock.tryLock()) {
            log.info("{} : can not acquire lock [{}], skipping this run.", (Object)messagePrefix, (Object)lockName);
            return;
        }
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.error("Error while running the runnable", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }
}

