/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.pagination.CursorType;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.audit.AuditingContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.dmz.pages.CommentManagerInternal;
import com.atlassian.confluence.dmz.relations.RelationManager;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.impl.content.DefaultContentEntityManager;
import com.atlassian.confluence.impl.security.PermissionPredicates;
import com.atlassian.confluence.internal.pages.persistence.CommentDaoInternal;
import com.atlassian.confluence.internal.persistence.ContentEntityObjectDaoInternal;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.NewCommentDeduplicator;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.CollaborativeEditingHelper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.WikiToStorageConverter;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.SessionFactory;

@ParametersAreNonnullByDefault
public class DefaultCommentManager
extends DefaultContentEntityManager
implements CommentManagerInternal {
    private final EventPublisher eventPublisher;
    private final CommentDaoInternal commentDao;
    private final PermissionManager permissionManager;
    private PermissionPredicates permissionPredicates;

    public DefaultCommentManager(ContentEntityObjectDaoInternal contentEntityObjectDao, SessionFactory sessionFactory, WikiToStorageConverter wikiToStorageConverter, EventPublisher eventPublisher, CommentDaoInternal commentDao, RelationManager relationManager, CollaborativeEditingHelper collaborativeEditingHelper, AuditingContext auditingContext, RetentionFeatureChecker retentionFeatureChecker, NotificationManager notificationManager, PermissionManager permissionManager) {
        super(contentEntityObjectDao, sessionFactory, wikiToStorageConverter, eventPublisher, relationManager, collaborativeEditingHelper, auditingContext, retentionFeatureChecker, DefaultCommentManager.eventFactory(), notificationManager);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.commentDao = (CommentDaoInternal)Preconditions.checkNotNull((Object)commentDao);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.permissionPredicates = new PermissionPredicates(permissionManager);
    }

    @Override
    public @Nullable Comment getComment(long id) {
        return this.commentDao.getById(id);
    }

    @Override
    public @NonNull Comment addCommentToPage(AbstractPage page, Comment parent, String content) {
        return this.addCommentToObject(page, parent, content);
    }

    @Override
    public @NonNull Comment addCommentToObject(ContentEntityObject ceo, Comment parent, String content) {
        Comment comment = this.saveComment(ceo, parent, content, null);
        this.publishCreateEvent(comment, null);
        return comment;
    }

    @Override
    public @NonNull Comment addCommentToObject(ContentEntityObject ceo, Comment parent, String content, @Nullable NewCommentDeduplicator commentDeduplicator) {
        Optional<Comment> existingComment;
        if (commentDeduplicator != null && (existingComment = commentDeduplicator.getDuplicateComment(ceo.getComments())).isPresent()) {
            return existingComment.get();
        }
        return this.saveComment(ceo, parent, content, commentDeduplicator);
    }

    private @NonNull Comment saveComment(ContentEntityObject ceo, @Nullable Comment parent, String content, @Nullable NewCommentDeduplicator commentDeduplicator) {
        Comment comment = new Comment();
        comment.setBodyAsString(content);
        this.commentDao.save(comment);
        ceo.addComment(comment);
        if (commentDeduplicator != null) {
            commentDeduplicator.newCommentSaved(comment);
        }
        if (parent != null) {
            parent.addChild(comment);
        }
        this.updateOutgoingLinks(comment);
        return comment;
    }

    private void updateOutgoingLinks(Comment comment) {
        this.eventPublisher.publish(linkManager -> linkManager.updateOutgoingLinks(comment));
    }

    @Override
    public void updateCommentContent(Comment comment, String content) {
        this.saveNewVersion(comment, comment1 -> comment1.setBodyAsString(content));
    }

    @Override
    public void removeCommentFromPage(long id) {
        this.removeCommentFromObject(id);
    }

    @Override
    public void removeCommentFromObject(long id) {
        Comment comment = this.getComment(id);
        if (comment == null) {
            return;
        }
        ContentEntityObject container = comment.getContainer();
        if (container != null) {
            container.removeComment(comment);
        }
        this.removeContentEntity(comment);
    }

    @Override
    public @NonNull Iterator<Comment> getRecentlyUpdatedComments(Space space, int maxResults) {
        return this.commentDao.getRecentlyUpdatedComments(space.getId(), maxResults);
    }

    @Override
    public @NonNull List<Comment> getPageComments(long pageId, Date since) {
        return this.commentDao.getContainerComments(pageId, since);
    }

    @Override
    public @NonNull List<Comment> getPageComments(long pageId, Date since, ConfluenceUser ignoreUser) {
        return this.commentDao.getContainerComments(pageId, since, ignoreUser);
    }

    @Override
    public @NonNull PageResponse<Comment> getFilteredContainerComments(long containerId, LimitedRequest pageRequest, Depth depth, Predicate<? super Comment> filter) {
        if (depth == Depth.ALL) {
            throw new UnsupportedOperationException("Call Page.getComments() instead.");
        }
        List<Comment> comments = this.commentDao.getContainerComments(containerId, pageRequest);
        return PageResponseImpl.filteredResponse((LimitedRequest)pageRequest, comments, filter);
    }

    @Override
    public @NonNull PageResponse<Comment> scanFilteredComments(Space space, List<ContentStatus> statuses, LimitedRequest pageRequest, Predicate<? super Comment> ... filter) {
        Objects.requireNonNull(pageRequest.getCursor());
        return DefaultCommentManager.filteredResponseWithCursor(pageRequest, this.permissionPredicates.andCanViewPredicate(filter), this.commentDao.scanFilteredSpaceComments(space, statuses, pageRequest), CursorType.COMMENT);
    }

    @Override
    public @NonNull PageResponse<Comment> scanFilteredComments(List<ContentStatus> statuses, LimitedRequest pageRequest, Predicate<? super Comment> ... filter) {
        Objects.requireNonNull(pageRequest.getCursor());
        return DefaultCommentManager.filteredResponseWithCursor(pageRequest, this.permissionPredicates.andCanViewPredicate(filter), this.commentDao.scanFilteredComments(statuses, pageRequest), CursorType.COMMENT);
    }

    @Override
    public long countSpaceCommentByStatuses(Space space, List<ContentStatus> contentStatuses) {
        return this.commentDao.countSpaceCommentByStatuses(space, contentStatuses);
    }

    @Override
    public long countCommentByStatuses(List<ContentStatus> contentStatuses) {
        return this.commentDao.countCommentByStatuses(contentStatuses);
    }

    @Override
    public @NonNull Map<Searchable, Integer> countComments(Collection<? extends Searchable> searchables) {
        return this.commentDao.countComments(searchables);
    }

    @Override
    public int countComments(Searchable searchable) {
        return this.commentDao.countComments(searchable);
    }

    @Override
    public int countAllCommentVersions() {
        return this.commentDao.countAllCommentVersions();
    }

    @Override
    public @NonNull Map<Long, Integer> countUnresolvedComments(Collection<Long> containerIds) {
        return this.commentDao.countUnresolvedComments(containerIds);
    }

    @Override
    public @NonNull PageResponse<Comment> getFilteredChildren(Comment comment, LimitedRequest pageRequest, Depth depth, Predicate<? super Comment> filter) {
        if (depth == Depth.ROOT) {
            return PageResponseImpl.filteredResponse((LimitedRequest)pageRequest, this.commentDao.getChildren(comment, pageRequest), filter);
        }
        throw new NotImplementedServiceException("Can only get Comment children at ROOT depth for now.");
    }

    private static DefaultContentEntityManager.EventFactory<Comment> eventFactory() {
        return new DefaultContentEntityManager.EventFactory<Comment>(){

            @Override
            public Optional<?> newCreateEvent(Comment obj, @Nullable SaveContext saveContext) {
                return Optional.of(new CommentCreateEvent(this, obj, saveContext));
            }

            @Override
            public Optional<?> newUpdateEvent(Comment obj, @Nullable Comment origObj, @Nullable SaveContext saveContext) {
                return Optional.of(new CommentUpdateEvent(this, obj, origObj, saveContext));
            }

            @Override
            public Optional<?> newRemoveEvent(Comment obj) {
                return Optional.of(new CommentRemoveEvent((Object)this, obj, AuthenticatedUserThreadLocal.get()));
            }
        };
    }

    @Override
    public @NonNull List<Comment> getPageLevelComments(long pageId, Date since) {
        return this.getPageLevelComments(this.commentDao.getContainerComments(pageId, since));
    }

    private @NonNull List<Comment> getPageLevelComments(List<Comment> comments) {
        ArrayList<Comment> pageLevelComments = new ArrayList<Comment>();
        for (Comment comment : comments) {
            if (comment.isInlineComment()) continue;
            pageLevelComments.add(comment);
        }
        return pageLevelComments;
    }
}

