/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.content.render.xhtml.links.LinksUpdater;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.impl.content.ContentLinkManager;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.TitleContentMapping;
import com.atlassian.confluence.links.TitleContentMappingManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultContentLinkManager
implements ContentLinkManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultContentLinkManager.class);
    private final TitleContentMappingManager titleContentMappingManager;
    private final PlatformTransactionManager transactionManager;
    private final LinkManager linkManager;
    private final ContentEntityManager contentEntityManager;
    private final LinksUpdater linksUpdater;
    private final PageManager pageManager;
    private final ClusterLockService clusterLockService;
    private static final String CONTENT_LINK_MANAGER_UPDATE_LOCK_NAME = "content.link.manager.update.lock";
    static final long CLUSTER_LOCK_MAX_WAIT_TIME_MS = 60000L;

    public DefaultContentLinkManager(TitleContentMappingManager titleContentMappingManager, PlatformTransactionManager transactionManager, ContentEntityManager contentEntityManager, LinkManager linkManager, PageManager pageManager, LinksUpdater linksUpdater, ClusterLockService clusterLockService) {
        this.titleContentMappingManager = titleContentMappingManager;
        this.transactionManager = transactionManager;
        this.contentEntityManager = contentEntityManager;
        this.linkManager = linkManager;
        this.pageManager = pageManager;
        this.linksUpdater = linksUpdater;
        this.clusterLockService = clusterLockService;
    }

    @Override
    public void processOldestLinkUpdate() throws InterruptedException {
        ClusterLock clusterLock = this.clusterLockService.getLockForName(CONTENT_LINK_MANAGER_UPDATE_LOCK_NAME);
        if (clusterLock == null) {
            log.info("cluster lock {} is null", (Object)CONTENT_LINK_MANAGER_UPDATE_LOCK_NAME);
            return;
        }
        if (!clusterLock.tryLock(60000L, TimeUnit.MILLISECONDS)) {
            log.info("Failed to acquire lock");
            return;
        }
        try {
            this.process();
        }
        catch (Exception ex) {
            log.error("Error while processing oldest link update", (Throwable)ex);
        }
        finally {
            clusterLock.unlock();
        }
    }

    @VisibleForTesting
    void process() {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.setReadOnly(true);
        List titleContentMappingList = (List)transactionTemplate.execute(tx -> this.titleContentMappingManager.getTitlesForOldestContentIdGroup());
        if (titleContentMappingList == null || titleContentMappingList.isEmpty()) {
            log.info("There are no oldest content links to be processed.");
            return;
        }
        long contentId = ((TitleContentMapping)titleContentMappingList.get(0)).getContentId();
        Set titles = titleContentMappingList.stream().map(TitleContentMapping::getTitle).collect(Collectors.toSet());
        ContentEntityObject ceo = (ContentEntityObject)transactionTemplate.execute(tx -> this.contentEntityManager.getById(contentId));
        transactionTemplate.setReadOnly(false);
        if (ceo == null || ceo.isDraft()) {
            log.info("Content is null or a draft. Deleting updates");
            transactionTemplate.execute(tx -> {
                for (TitleContentMapping mapping : titleContentMappingList) {
                    this.titleContentMappingManager.deleteByTitle(mapping.getTitle(), mapping.getContentId());
                }
                return null;
            });
            return;
        }
        SpaceContentEntityObject spaceContentEntityObject = (SpaceContentEntityObject)ceo.getLatestVersion();
        LinksUpdater.PartialReferenceDetails newDetails = LinksUpdater.PartialReferenceDetails.createReference(spaceContentEntityObject);
        for (String title : titles) {
            SpaceContentEntityObject oldEntity = this.getOldEntity(title, spaceContentEntityObject);
            LinksUpdater.PartialReferenceDetails oldDetails = LinksUpdater.PartialReferenceDetails.createReference(oldEntity);
            try {
                transactionTemplate.execute(tx -> {
                    Collection<ContentEntityObject> referringContents = this.linkManager.getReferringContent(oldEntity);
                    for (ContentEntityObject referringContent : referringContents) {
                        this.updateContent(referringContent, newDetails, oldDetails);
                    }
                    this.titleContentMappingManager.deleteByTitle(title, ceo.getId());
                    return null;
                });
            }
            catch (Exception ex) {
                log.error("Error updating links for content = {}, title = {}", new Object[]{spaceContentEntityObject.getId(), title, ex});
            }
        }
    }

    @VisibleForTesting
    SpaceContentEntityObject getOldEntity(String title, SpaceContentEntityObject spaceContentEntityObject) {
        if (spaceContentEntityObject instanceof BlogPost) {
            BlogPost blogPost = new BlogPost();
            blogPost.setTitle(title);
            blogPost.setSpace(spaceContentEntityObject.getSpace());
            blogPost.setCreationDate(spaceContentEntityObject.getCreationDate());
            return blogPost;
        }
        Page page = new Page();
        page.setTitle(title);
        page.setSpace(spaceContentEntityObject.getSpace());
        return page;
    }

    @VisibleForTesting
    void updateContent(ContentEntityObject referringContent, LinksUpdater.PartialReferenceDetails newDetails, LinksUpdater.PartialReferenceDetails oldDetails) {
        if (!BodyType.XHTML.equals(referringContent.getBodyContent().getBodyType())) {
            return;
        }
        String expandedContent = referringContent instanceof SpaceContentEntityObject ? this.linksUpdater.expandRelativeReferencesInContent((SpaceContentEntityObject)referringContent) : (referringContent instanceof Comment ? this.linksUpdater.expandRelativeReferencesInContent((Comment)referringContent) : referringContent.getBodyAsString());
        String updatedContent = this.linksUpdater.updateReferencesInContent(expandedContent, oldDetails, newDetails);
        referringContent.setBodyAsString(updatedContent);
        String contentConversion = referringContent instanceof SpaceContentEntityObject ? this.linksUpdater.contractAbsoluteReferencesInContent((SpaceContentEntityObject)referringContent) : referringContent.getBodyAsString();
        referringContent.setBodyAsString(contentConversion);
        this.pageManager.saveContentEntity(referringContent, DefaultSaveContext.REFACTORING);
    }
}

