/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content;

import bucket.user.propertyset.BucketPropertySetItem;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cache.CoreCache;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.impl.cache.ReadThroughAtlassianCache;
import com.atlassian.confluence.impl.cache.ReadThroughCache;
import com.atlassian.confluence.impl.neops.NeoPropertySetItem;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.SessionFactory;

public class DefaultContentPropertyManager
implements ContentPropertyManager {
    public static final String ENTITY_NAME = "confluence_ContentEntityObject";
    private final ReadThroughCache<String, Option<String>> cache;
    private final SessionFactory sessionFactory;

    public DefaultContentPropertyManager(SessionFactory sessionFactory, ReadThroughCache<String, Option<String>> cache) {
        this.sessionFactory = sessionFactory;
        this.cache = cache;
    }

    public static DefaultContentPropertyManager create(SessionFactory sessionFactory, CacheFactory cacheFactory) {
        return new DefaultContentPropertyManager(sessionFactory, ReadThroughAtlassianCache.create(cacheFactory, CoreCache.CONTENT_PROPERTY_MANAGER));
    }

    public static String cacheKey(ContentEntityObject entity, String key) {
        return "%s-%s".formatted(entity.getIdAsString(), key);
    }

    private void removeFromCache(ContentEntityObject entity, String key) {
        String cacheKey = DefaultContentPropertyManager.cacheKey(entity, key);
        this.cache.remove(cacheKey);
    }

    @Override
    public @Nullable String getStringProperty(ContentEntityObject entity, String key) {
        return (String)this.cache.get(DefaultContentPropertyManager.cacheKey(entity, key), () -> Option.fromOptional(this.findPropertySetItem(entity, key).map(DefaultContentPropertyManager::fromPropertySetItem))).getOrNull();
    }

    private static String fromPropertySetItem(BucketPropertySetItem item) {
        return switch (item.getPropertyType()) {
            case NeoPropertySetItem.PropertyType.STRING -> item.getStringVal();
            case NeoPropertySetItem.PropertyType.TEXT -> item.getTextVal();
            default -> null;
        };
    }

    @Override
    public void setStringProperty(ContentEntityObject entity, String key, String value) {
        Validate.inclusiveBetween((long)1L, (long)200L, (long)key.length());
        BucketPropertySetItem item = this.findOrEmptyPropertySetItem(entity, key);
        if (value == null || value.length() <= 255) {
            item.setStringVal(value);
        } else {
            item.setTextVal(StringUtils.left((String)value, (int)100000));
        }
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)item);
        this.removeFromCache(entity, key);
    }

    @Override
    public void removeProperty(ContentEntityObject entity, String key) {
        this.findPropertySetItem(entity, key).ifPresent(item -> this.sessionFactory.getCurrentSession().delete(item));
        this.removeFromCache(entity, key);
    }

    @Override
    public void removeProperties(ContentEntityObject entity) {
        this.findPropertySetItems(entity).forEach(item -> {
            this.sessionFactory.getCurrentSession().delete(item);
            this.removeFromCache(entity, item.getKey());
        });
    }

    @Override
    public void transferProperties(ContentEntityObject source, ContentEntityObject destination) {
        Objects.requireNonNull(destination);
        this.findPropertySetItems(source).forEach(item -> {
            String value = DefaultContentPropertyManager.fromPropertySetItem(item);
            if (value == null) {
                return;
            }
            this.setStringProperty(destination, item.getKey(), value);
            this.sessionFactory.getCurrentSession().delete(item);
            this.removeFromCache(source, item.getKey());
        });
    }

    private List<BucketPropertySetItem> findPropertySetItems(ContentEntityObject entity) {
        Objects.requireNonNull(entity);
        return this.sessionFactory.getCurrentSession().createQuery("from BucketPropertySetItem where entityName=:name and entityId=:id", BucketPropertySetItem.class).setParameter("name", (Object)ENTITY_NAME).setParameter("id", (Object)entity.getId()).list();
    }

    private BucketPropertySetItem findOrEmptyPropertySetItem(ContentEntityObject entity, String key) {
        return this.findPropertySetItem(entity, key).orElseGet(() -> new BucketPropertySetItem(ENTITY_NAME, entity.getId(), key));
    }

    private Optional<BucketPropertySetItem> findPropertySetItem(ContentEntityObject entity, String key) {
        Objects.requireNonNull(entity);
        Objects.requireNonNull(key);
        return this.sessionFactory.getCurrentSession().createQuery("from BucketPropertySetItem where entityName=:name and entityId=:id and key=:key", BucketPropertySetItem.class).setParameter("name", (Object)ENTITY_NAME).setParameter("id", (Object)entity.getId()).setParameter("key", (Object)key).uniqueResultOptional();
    }
}

