/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.audit.AuditingContext;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.dmz.relations.RelationManager;
import com.atlassian.confluence.event.events.content.user.PersonalInformationCreateEvent;
import com.atlassian.confluence.event.events.content.user.PersonalInformationRemoveEvent;
import com.atlassian.confluence.event.events.content.user.PersonalInformationUpdateEvent;
import com.atlassian.confluence.impl.content.DefaultContentEntityManager;
import com.atlassian.confluence.internal.persistence.ContentEntityObjectDaoInternal;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.setup.settings.CollaborativeEditingHelper;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.persistence.dao.PersonalInformationDao;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.confluence.xhtml.api.WikiToStorageConverter;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DefaultPersonalInformationManager
implements PersonalInformationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPersonalInformationManager.class);
    private final PersonalInformationDao personalInformationDao;
    private final ContentEntityManager contentEntityManager;

    public DefaultPersonalInformationManager(ContentEntityObjectDaoInternal contentEntityObjectDao, SessionFactory sessionFactory, WikiToStorageConverter wikiToStorageConverter, EventPublisher eventPublisher, PersonalInformationDao personalInformationDao, RelationManager relationManager, CollaborativeEditingHelper collaborativeEditingHelper, AuditingContext auditingContext, RetentionFeatureChecker retentionFeatureChecker, NotificationManager notificationManager) {
        this.contentEntityManager = new DefaultContentEntityManager(contentEntityObjectDao, sessionFactory, wikiToStorageConverter, eventPublisher, relationManager, collaborativeEditingHelper, auditingContext, retentionFeatureChecker, DefaultPersonalInformationManager.eventFactory(), notificationManager);
        this.personalInformationDao = (PersonalInformationDao)Preconditions.checkNotNull((Object)personalInformationDao);
    }

    @Override
    public @NonNull PersonalInformation getOrCreatePersonalInformation(User user) {
        Preconditions.checkNotNull((Object)user);
        ConfluenceUser confluenceUser = FindUserHelper.getUser(user);
        if (confluenceUser == null) {
            throw new NullPointerException("Unable to find user mapping for " + user.getName());
        }
        PersonalInformation result = this.personalInformationDao.getByUser(confluenceUser);
        if (result == null) {
            log.debug("Creating PersonalInformation for {}", (Object)user.getName());
            result = new PersonalInformation();
            result.setUser(confluenceUser);
            this.contentEntityManager.saveContentEntity(result, null);
        }
        return result;
    }

    @Override
    public @NonNull PersonalInformation createPersonalInformation(User user) {
        return this.getOrCreatePersonalInformation(user);
    }

    @Override
    public void savePersonalInformation(PersonalInformation newInfo, @Nullable PersonalInformation oldInfo) {
        this.contentEntityManager.saveContentEntity(newInfo, oldInfo, null);
    }

    @Override
    public void savePersonalInformation(User user, String newInfoString, String fullName) {
        PersonalInformation current = this.getOrCreatePersonalInformation(user);
        this.contentEntityManager.saveNewVersion(current, personalInformation -> personalInformation.setBodyAsString(newInfoString.trim()));
    }

    @Override
    public void removePersonalInformation(@Nullable ConfluenceUser user) {
        if (user == null) {
            return;
        }
        List<PersonalInformation> infos = this.personalInformationDao.getAllByUser(user);
        if (infos.isEmpty()) {
            log.debug("No PersonalInformation found for user '{}'; Nothing to remove.", (Object)user.getName());
            return;
        }
        infos.stream().forEach(this.contentEntityManager::removeContentEntity);
    }

    private static DefaultContentEntityManager.EventFactory<PersonalInformation> eventFactory() {
        return new DefaultContentEntityManager.EventFactory<PersonalInformation>(){

            @Override
            public Optional<?> newCreateEvent(PersonalInformation obj, @Nullable SaveContext saveContext) {
                return Optional.of(new PersonalInformationCreateEvent((Object)this, obj, saveContext));
            }

            @Override
            public Optional<?> newUpdateEvent(PersonalInformation object, @Nullable PersonalInformation origObject, @Nullable SaveContext saveContext) {
                boolean suppressNotifications = saveContext != null && saveContext.isSuppressNotifications();
                return Optional.of(new PersonalInformationUpdateEvent(this, object, origObject, suppressNotifications));
            }

            @Override
            public Optional<?> newRemoveEvent(PersonalInformation obj) {
                return Optional.of(new PersonalInformationRemoveEvent((Object)this, obj, false));
            }
        };
    }

    @Override
    public boolean hasPersonalInformation(@Nullable String username) {
        ConfluenceUser user = FindUserHelper.getUserByUsername(username);
        return user != null && this.personalInformationDao.getByUser(user) != null;
    }

    @Override
    public boolean hasPersonalInformation(@Nullable UserKey userKey) {
        ConfluenceUser user = FindUserHelper.getUserByUserKey(userKey);
        return user != null && this.personalInformationDao.getByUser(user) != null;
    }
}

