/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.audit.AuditingContext;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.dmz.relations.RelationManager;
import com.atlassian.confluence.impl.content.DefaultContentEntityManager;
import com.atlassian.confluence.internal.persistence.ContentEntityObjectDaoInternal;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.setup.settings.CollaborativeEditingHelper;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceDescriptionManager;
import com.atlassian.confluence.xhtml.api.WikiToStorageConverter;
import com.atlassian.event.api.EventPublisher;
import org.hibernate.SessionFactory;

@ParametersAreNonnullByDefault
public class DefaultSpaceDescriptionManager
implements SpaceDescriptionManager {
    private final ContentEntityManager contentEntityManager;

    DefaultSpaceDescriptionManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public DefaultSpaceDescriptionManager(ContentEntityObjectDaoInternal contentEntityObjectDao, SessionFactory sessionFactory, WikiToStorageConverter wikiToStorageConverter, EventPublisher eventPublisher, RelationManager relationManager, CollaborativeEditingHelper collaborativeEditingHelper, AuditingContext auditingContext, RetentionFeatureChecker retentionFeatureChecker, NotificationManager notificationManager) {
        this(new DefaultContentEntityManager(contentEntityObjectDao, sessionFactory, wikiToStorageConverter, eventPublisher, relationManager, collaborativeEditingHelper, auditingContext, retentionFeatureChecker, DefaultContentEntityManager.EventFactory.noEvents(), notificationManager));
    }

    @Override
    public void update(SpaceDescription description, SpaceDescription original) {
        this.contentEntityManager.saveContentEntity(description, original, null);
    }

    @Override
    public void remove(SpaceDescription desc) {
        this.contentEntityManager.removeContentEntity(desc);
    }

    @Override
    public void save(SpaceDescription description) {
        this.contentEntityManager.saveContentEntity(description, null);
    }
}

