/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content.datasource;

import com.atlassian.confluence.impl.content.datasource.NamedDataSource;
import com.atlassian.confluence.impl.content.datasource.ThumbnailDataSourceFactory;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import jakarta.activation.DataSource;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;

final class AttachmentDataSourceFactory {
    private final AttachmentManager attachmentManager;
    private final ThumbnailDataSourceFactory thumbnailDataSourceFactory;

    AttachmentDataSourceFactory(AttachmentManager attachmentManager, ThumbnailDataSourceFactory thumbnailDataSourceFactory) {
        this.attachmentManager = attachmentManager;
        this.thumbnailDataSourceFactory = thumbnailDataSourceFactory;
    }

    DataSource getDataSource(Attachment attachment, boolean useThumbnail) throws IOException {
        Optional<DataSource> thumbDataSource;
        DataSource dataSource = useThumbnail ? ((thumbDataSource = this.thumbnailDataSourceFactory.getDataSource(attachment)).isPresent() ? thumbDataSource.get() : this.getDataSource(attachment)) : this.getDataSource(attachment);
        return new NamedDataSource(dataSource, "attach_" + DigestUtils.sha256Hex((String)attachment.getDownloadPath()));
    }

    DataSource getDataSource(Attachment attachment) throws IOException {
        try (InputStream is = this.attachmentManager.getAttachmentData(attachment);){
            ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(is, attachment.getMediaType());
            return byteArrayDataSource;
        }
    }
}

