/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content.datasource;

import com.atlassian.confluence.impl.content.datasource.NamedDataSource;
import com.atlassian.confluence.impl.content.datasource.ServletContextDataSourceFactory;
import com.atlassian.confluence.user.UserProfilePictureAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.user.User;
import jakarta.activation.DataSource;
import jakarta.activation.URLDataSource;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AvatarDataSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(AvatarDataSourceFactory.class);
    private final UserProfilePictureAccessor userProfilePictureAccessor;
    private final ServletContextDataSourceFactory servletContextResolver;

    AvatarDataSourceFactory(UserProfilePictureAccessor userProfilePictureAccessor, ServletContextDataSourceFactory servletContextResolver) {
        this.userProfilePictureAccessor = userProfilePictureAccessor;
        this.servletContextResolver = servletContextResolver;
    }

    DataSource getDataSource(User user) {
        DataSource profilePicture;
        ProfilePictureInfo profilePictureInfo = this.userProfilePictureAccessor.getUserProfilePicture(user);
        if (!profilePictureInfo.isExternal()) {
            try (InputStream is = profilePictureInfo.getBytes();){
                if (!profilePictureInfo.isDefault() && !profilePictureInfo.isAnonymousPicture() && is != null) {
                    profilePicture = new ByteArrayDataSource(is, profilePictureInfo.getContentType());
                }
                if (profilePictureInfo.isAnonymousPicture()) {
                    profilePicture = this.servletContextResolver.getDataSource("/images/icons/profilepics/anonymous.png");
                }
                profilePicture = this.servletContextResolver.getDataSource("/images/icons/profilepics/default.png");
            }
            catch (IOException e) {
                String name = user == null ? "null" : user.getName();
                log.warn("Error getting profile picture for user=[{}], profilePicture=[{}] : {}", new Object[]{name, ToStringBuilder.reflectionToString((Object)profilePictureInfo), e.getMessage(), e});
                try {
                    profilePicture = this.servletContextResolver.getDataSource("/images/icons/profilepics/default.png");
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        } else {
            profilePicture = AvatarDataSourceFactory.getExternalAvatarResource(profilePictureInfo.getUriReference());
        }
        String avatarContentId = this.getAvatarContentId(user, profilePicture);
        return new NamedDataSource(profilePicture, avatarContentId);
    }

    private String getAvatarContentId(User modifier, DataSource profilePicture) {
        String username = modifier != null ? modifier.getName() : "anonymous";
        String avatar = !StringUtils.isEmpty((CharSequence)profilePicture.getName()) ? profilePicture.getName() : this.userProfilePictureAccessor.getUserProfilePicture(modifier).getFileName();
        return "avatar_" + DigestUtils.sha256Hex((String)(username + avatar));
    }

    private static DataSource getExternalAvatarResource(String uriReference) {
        try {
            return new URLDataSource(new URL(uriReference));
        }
        catch (MalformedURLException e) {
            log.warn("Malformed avatar url {}", (Object)uriReference);
            throw new RuntimeException(e);
        }
    }
}

