/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content.datasource;

import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.content.datasource.ResourceModuleDescriptor;
import com.atlassian.confluence.core.PluginDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.AttachmentDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.AvatarDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.NamedDataSource;
import com.atlassian.confluence.impl.content.datasource.PluginDataSourceFactoryFactory;
import com.atlassian.confluence.impl.content.datasource.ServletContextDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.SpaceLogoDataSourceFactory;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.ModuleCompleteKey;
import com.google.common.collect.Iterables;
import jakarta.activation.URLDataSource;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CompositeDataSourceFactory
implements DataSourceFactory {
    private final ServletContextDataSourceFactory servletContextDataSourceFactory;
    private final AvatarDataSourceFactory avatarDataSourceFactory;
    private final AttachmentDataSourceFactory attachmentDataSourceFactory;
    private final SpaceLogoDataSourceFactory spaceLogoDataSourceFactory;
    private final PluginDataSourceFactoryFactory pluginDataSourceFactoryFactory;

    CompositeDataSourceFactory(ServletContextDataSourceFactory servletContextDataSourceFactory, AvatarDataSourceFactory avatarDataSourceFactory, AttachmentDataSourceFactory attachmentDataSourceFactory, SpaceLogoDataSourceFactory spaceLogoDataSourceFactory, PluginDataSourceFactoryFactory pluginDataSourceFactoryFactory) {
        this.servletContextDataSourceFactory = servletContextDataSourceFactory;
        this.avatarDataSourceFactory = avatarDataSourceFactory;
        this.attachmentDataSourceFactory = attachmentDataSourceFactory;
        this.spaceLogoDataSourceFactory = spaceLogoDataSourceFactory;
        this.pluginDataSourceFactoryFactory = pluginDataSourceFactoryFactory;
    }

    @Override
    public DataSource getAvatar(ConfluenceUser user) {
        return DataSource.from(this.avatarDataSourceFactory.getDataSource(user));
    }

    @Override
    public DataSource getSpaceLogo(Space space) throws IOException {
        return DataSource.from(this.spaceLogoDataSourceFactory.getDataSource(space));
    }

    @Override
    public DataSource getServletContainerResource(String path, String name) throws IOException {
        return DataSource.from(new NamedDataSource(this.servletContextDataSourceFactory.getDataSource(path), name));
    }

    @Override
    public DataSource getDatasource(Attachment attachment, boolean useThumbnail) throws IOException {
        return DataSource.from(this.attachmentDataSourceFactory.getDataSource(attachment, useThumbnail));
    }

    @Override
    public DataSource getURLResource(URL url, String name) {
        return DataSource.from(new NamedDataSource((jakarta.activation.DataSource)new URLDataSource(url), name));
    }

    @Override
    public DataSource getDataSource(InputStream inputStream, String mimeType) throws IOException {
        return DataSource.from((jakarta.activation.DataSource)new ByteArrayDataSource(inputStream, mimeType));
    }

    @Override
    public DataSource getDataSource(byte[] bytes, String mimeType) {
        return DataSource.from((jakarta.activation.DataSource)new ByteArrayDataSource(bytes, mimeType));
    }

    @Override
    public Optional<DataSource> getResourceFromModuleByName(ModuleCompleteKey moduleKey, String resourceName) {
        return this.pluginDataSourceFactoryFactory.createDataSourceFactory(moduleKey.getPluginKey()).flatMap(factory -> factory.getResourceFromModuleByName(moduleKey.getModuleKey(), resourceName)).map(DataSource::from);
    }

    @Override
    public Iterable<DataSource> getResourcesFromModules(ModuleCompleteKey moduleKey, @Nullable Predicate<ResourceModuleDescriptor> filter) {
        return this.pluginDataSourceFactoryFactory.createDataSourceFactory(moduleKey.getPluginKey()).flatMap(factory -> factory.getResourcesFromModules(moduleKey.getModuleKey(), filter == null ? null : resourceView -> filter.test(CompositeDataSourceFactory.translate(resourceView)))).map(dss -> Iterables.transform((Iterable)dss, DataSource::from)).orElse(Collections.emptySet());
    }

    private static ResourceModuleDescriptor translate(final PluginDataSourceFactory.ResourceView resourceView) {
        return new ResourceModuleDescriptor(){

            @Override
            public String name() {
                return resourceView.name();
            }

            @Override
            public String contentType() {
                return resourceView.contentType();
            }

            @Override
            public String type() {
                return resourceView.type();
            }

            @Override
            public Map<String, String> params() {
                return resourceView.params();
            }
        };
    }
}

