/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content.datasource;

import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.AttachmentDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.AvatarDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.CompositeDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.PluginDataSourceFactoryFactory;
import com.atlassian.confluence.impl.content.datasource.ServletContextDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.SpaceLogoDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.ThumbnailDataSourceFactory;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.spaces.SpaceLogoManager;
import com.atlassian.confluence.user.UserProfilePictureAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import jakarta.activation.FileTypeMap;
import jakarta.activation.MimetypesFileTypeMap;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ResourceLoader;

@Configuration
class DataSourceFactoryConfiguration {
    @Resource
    UserProfilePictureAccessor userProfilePictureAccessor;
    @Resource
    AttachmentManager attachmentManager;
    @Resource
    ThumbnailManager thumbnailManager;
    @Resource
    PluginAccessor pluginAccessor;
    @Resource
    SpaceLogoManager spaceLogoManager;

    DataSourceFactoryConfiguration() {
    }

    @Bean
    @AvailableToPlugins(interfaces={DataSourceFactory.class})
    CompositeDataSourceFactory dataSourceFactory(ResourceLoader resourceLoader) throws Exception {
        MimetypesFileTypeMap fileTypeMap = DataSourceFactoryConfiguration.createFileTypeMap();
        ServletContextDataSourceFactory servletContextDataSourceFactory = new ServletContextDataSourceFactory(resourceLoader, (FileTypeMap)fileTypeMap);
        AttachmentDataSourceFactory attachmentDataSourceFactory = new AttachmentDataSourceFactory(this.attachmentManager, new ThumbnailDataSourceFactory(this.thumbnailManager));
        return new CompositeDataSourceFactory(servletContextDataSourceFactory, new AvatarDataSourceFactory(this.userProfilePictureAccessor, servletContextDataSourceFactory), attachmentDataSourceFactory, new SpaceLogoDataSourceFactory(this.spaceLogoManager, this.attachmentManager, attachmentDataSourceFactory, servletContextDataSourceFactory), new PluginDataSourceFactoryFactory(this.pluginAccessor, (FileTypeMap)fileTypeMap, resourceLoader));
    }

    private static MimetypesFileTypeMap createFileTypeMap() throws IOException {
        try (InputStream is = new ClassPathResource("mime.types").getInputStream();){
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(is);
            return mimetypesFileTypeMap;
        }
    }
}

