/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content.datasource;

import com.atlassian.confluence.core.PluginDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.DefaultPluginDataSourceFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import io.atlassian.fugue.Pair;
import jakarta.activation.FileTypeMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.springframework.core.io.ResourceLoader;

final class PluginDataSourceFactoryFactory {
    private final PluginAccessor pluginAccessor;
    private final FileTypeMap fileTypeMap;
    private final java.util.function.Function<Pair<Plugin, PluginDataSourceFactory.ResourceView>, InputStream> resourceStreamFactory;

    PluginDataSourceFactoryFactory(PluginAccessor pluginAccessor, FileTypeMap fileTypeMap, ResourceLoader resourceLoader) {
        this.pluginAccessor = pluginAccessor;
        this.fileTypeMap = fileTypeMap;
        this.resourceStreamFactory = resource -> {
            String location = ((PluginDataSourceFactory.ResourceView)resource.right()).location();
            InputStream inputStream = ((Plugin)resource.left()).getResourceAsStream(location);
            if (inputStream != null) {
                return inputStream;
            }
            try {
                return resourceLoader.getResource(location).getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        };
    }

    Optional<DefaultPluginDataSourceFactory> createDataSourceFactory(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            return Optional.empty();
        }
        return Optional.of(new DefaultPluginDataSourceFactory(this.fileTypeMap, (Function<Pair<Plugin, PluginDataSourceFactory.ResourceView>, InputStream>)((Function)this.resourceStreamFactory::apply), plugin));
    }
}

