/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content.datasource;

import jakarta.activation.DataSource;
import jakarta.activation.FileTypeMap;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ResourceLoader;

final class ServletContextDataSourceFactory {
    private final ResourceLoader resourceLoader;
    private final FileTypeMap fileTypeMap;

    ServletContextDataSourceFactory(ResourceLoader resourceLoader, FileTypeMap fileTypeMap) {
        this.resourceLoader = resourceLoader;
        this.fileTypeMap = fileTypeMap;
    }

    DataSource getDataSource(String path) throws IOException {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("Path is required.");
        }
        String filename = StringUtils.substringAfterLast((String)path, (String)"/");
        String mimeType = this.fileTypeMap.getContentType(filename);
        try (InputStream is = this.resourceLoader.getResource(path).getInputStream();){
            ByteArrayDataSource urlResource = new ByteArrayDataSource(is, mimeType);
            urlResource.setName(filename);
            ByteArrayDataSource byteArrayDataSource = urlResource;
            return byteArrayDataSource;
        }
    }
}

