/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content.datasource;

import com.atlassian.confluence.impl.content.datasource.AttachmentDataSourceFactory;
import com.atlassian.confluence.impl.content.datasource.NamedDataSource;
import com.atlassian.confluence.impl.content.datasource.ServletContextDataSourceFactory;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceLogoManager;
import jakarta.activation.DataSource;
import java.io.IOException;

final class SpaceLogoDataSourceFactory {
    private final SpaceLogoManager spaceLogoManager;
    private final AttachmentManager attachmentManager;
    private final AttachmentDataSourceFactory attachmentDataSourceFactory;
    private final ServletContextDataSourceFactory servletContextResolver;

    SpaceLogoDataSourceFactory(SpaceLogoManager spaceLogoManager, AttachmentManager attachmentManager, AttachmentDataSourceFactory attachmentDataSourceFactory, ServletContextDataSourceFactory servletContextResolver) {
        this.spaceLogoManager = spaceLogoManager;
        this.attachmentManager = attachmentManager;
        this.attachmentDataSourceFactory = attachmentDataSourceFactory;
        this.servletContextResolver = servletContextResolver;
    }

    DataSource getDataSource(Space space) throws IOException {
        DataSource logoDataSource;
        String logoPath = this.spaceLogoManager.getLogoDownloadPath(space, null);
        String spaceKey = space.getKey();
        if ("/images/logo/default-space-logo.svg".equals(logoPath)) {
            logoDataSource = this.servletContextResolver.getDataSource("/images/logo/default-space-logo.svg");
        } else {
            try {
                logoDataSource = this.getDataSourceFromAttachmentDownloadPath(logoPath);
            }
            catch (Exception e) {
                logoDataSource = this.servletContextResolver.getDataSource("/images/logo/default-space-logo.svg");
            }
        }
        String spaceLogoContentId = spaceKey + "-space-logo";
        return new NamedDataSource(logoDataSource, spaceLogoContentId);
    }

    private DataSource getDataSourceFromAttachmentDownloadPath(String downloadPath) throws IOException {
        Attachment attachment = this.attachmentManager.findAttachmentForDownloadPath(downloadPath).orElseThrow();
        return this.attachmentDataSourceFactory.getDataSource(attachment);
    }
}

