/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content.datasource;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.core.util.thumbnail.Thumbnail;
import jakarta.activation.DataSource;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

final class ThumbnailDataSourceFactory {
    private final ThumbnailManager thumbnailManager;

    ThumbnailDataSourceFactory(ThumbnailManager thumbnailManager) {
        this.thumbnailManager = thumbnailManager;
    }

    Optional<DataSource> getDataSource(Attachment attachment) throws IOException {
        Thumbnail thumb;
        if (this.thumbnailManager.isThumbnailable(attachment) && (thumb = this.thumbnailManager.getThumbnail(attachment)) != null && thumb.getMimeType() != null) {
            try (InputStream is = this.thumbnailManager.getThumbnailData(attachment);){
                Optional<ByteArrayDataSource> optional = Optional.of(new ByteArrayDataSource(is, thumb.getMimeType().toString()));
                return optional;
            }
        }
        return Optional.empty();
    }
}

