/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.content.render.prefetch.hibernate;

import com.google.common.collect.Lists;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernatePrefetchHelper {
    private static final Logger log = LoggerFactory.getLogger(HibernatePrefetchHelper.class);
    private final Session session;

    public HibernatePrefetchHelper(Session session) {
        this.session = Objects.requireNonNull(session);
    }

    public <T> Collection<T> prefetchEntitiesById(String idPropertyName, Collection<?> ids, Class<T> entityType) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        CriteriaBuilder builder = this.session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(entityType);
        Root root = query.from(entityType);
        query.where((Expression)builder.in((Expression)root.get(idPropertyName)).in(ids));
        List results = this.session.createQuery(query).list();
        log.debug("Prefetched {} {} entities with IDs {}", new Object[]{results.size(), entityType.getSimpleName(), ids});
        return results;
    }

    public static <I, O> Collection<O> partitionedQuery(Collection<I> inputItems, int partitionSize, Function<Collection<I>, Collection<O>> query) {
        return Lists.partition(new ArrayList<I>(inputItems), (int)partitionSize).stream().flatMap(partition -> ((Collection)query.apply((Collection)partition)).stream()).collect(Collectors.toList());
    }
}

