/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.core.persistence.hibernate;

import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.PersistentDecorator;
import com.atlassian.confluence.core.VersionHistory;
import com.atlassian.confluence.core.persistence.hibernate.HibernateDatabaseCapabilities;
import com.atlassian.confluence.follow.Connection;
import com.atlassian.confluence.impl.labels.adaptivelabelcache.dao.MostUsedLabelsCacheRecord;
import com.atlassian.confluence.impl.plugin.settings.PluginSetting;
import com.atlassian.confluence.incrementalsync.IncrementalSyncSubscriptionEntity;
import com.atlassian.confluence.incrementalsync.SpaceInclusionEntity;
import com.atlassian.confluence.internal.diagnostics.persistence.dao.hibernate.AlertEntityImpl;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.like.LikeEntity;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.links.TitleContentMapping;
import com.atlassian.confluence.pages.AttachmentData;
import com.atlassian.confluence.pages.attachments.ImageDetailsDto;
import com.atlassian.confluence.plugin.persistence.PluginData;
import com.atlassian.confluence.plugin.persistence.PluginDataWithoutBinary;
import com.atlassian.confluence.security.persistence.dao.hibernate.UserLoginInfo;
import com.atlassian.confluence.user.persistence.dao.ConfluenceRememberMeToken;
import com.atlassian.synchrony.Events;
import com.atlassian.synchrony.Secrets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class HibernateMappingFactory {
    private final Set<Class<?>> annotatedClasses = Set.of(BodyContent.class, Connection.class, IncrementalSyncSubscriptionEntity.class, Label.class, Labelling.class, PluginSetting.class, OutgoingLink.class, Secrets.class, SpaceInclusionEntity.class, TitleContentMapping.class, MostUsedLabelsCacheRecord.class, AlertEntityImpl.class, Events.class, LikeEntity.class, UserLoginInfo.class, ConfluenceRememberMeToken.class, AttachmentData.class, PluginData.class, PluginDataWithoutBinary.class, VersionHistory.class, PersistentDecorator.class, ImageDetailsDto.class);
    private final Set<Resource> commonResources = Set.of(new ClassPathResource("com/atlassian/confluence/core/ContentEntityObject.hbm.xml"), new ClassPathResource("com/atlassian/confluence/mail/notification/Notification.hbm.xml"), new ClassPathResource("com/atlassian/confluence/pages/AttachmentQueries.hbm.xml"), new ClassPathResource("com/atlassian/confluence/pages/templates/PageTemplate.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/SpacePermission.hbm.xml"), new ClassPathResource("com/atlassian/confluence/spaces/Space.hbm.xml"), new ClassPathResource("com/atlassian/confluence/user/PropertySetItem.hbm.xml"), new ClassPathResource("com/atlassian/confluence/setup/bandana/ConfluenceBandanaRecord.hbm.xml"), new ClassPathResource("com/atlassian/confluence/core/ClusterSafetyNumber.hbm.xml"), new ClassPathResource("com/atlassian/confluence/core/ZduStatusEntity.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/ContentPermission.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/ContentPermissionSet.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/KeyStore.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/TrustedApplication.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/TrustedApplicationRestriction.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedContent.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedContentViewPermission.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedLock.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedServiceStateRecord.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedSid.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedSpacePermission.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedStateChangeLog.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/backgroundjob/ArchivedBackgroundJob.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/backgroundjob/BackgroundJob.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/backuprestore/BackupRestoreJob.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/backuprestore/BackupRestoreJobSettings.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/backuprestore/BackupRestoreJobStatistics.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/HibernateApplication.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/HibernateDirectory.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/HibernateDirectorySynchronisationStatus.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/HibernateDirectorySynchronisationToken.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/HibernateGroup.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/HibernateMembership.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/HibernateTombstone.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/HibernateUser.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/ResourceRestriction.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/ServiceAccount.hbm.xml"), new ClassPathResource("com/atlassian/confluence/impl/crowd/ServiceAccountAuthMethod.hbm.xml"), new ClassPathResource("com/atlassian/confluence/user/ConfluenceUser.hbm.xml"), new ClassPathResource("com/atlassian/confluence/relations/RelationEntity.hbm.xml"), new ClassPathResource("com/atlassian/confluence/schedule/service/Scheduler.hbm.xml"), new ClassPathResource("com/atlassian/confluence/audit/AuditRecord.hbm.xml"), new ClassPathResource("com/atlassian/synchrony/Snapshots.hbm.xml"), new ClassPathResource("com/atlassian/confluence/security/legacy/LegacySecurityMappings.hbm.xml"));
    private final HibernateDatabaseCapabilities databaseCapabilities;

    public HibernateMappingFactory(HibernateDatabaseCapabilities databaseCapabilities) {
        this.databaseCapabilities = Objects.requireNonNull(databaseCapabilities);
    }

    public Collection<Resource> hibernateMappingResources() {
        return Sets.union(this.commonResources, this.buildCapabilitySpecificMappings());
    }

    public Collection<Class<?>> annotatedClasses() {
        return this.annotatedClasses;
    }

    private Set<Resource> buildCapabilitySpecificMappings() {
        ImmutableSet.Builder mappings = ImmutableSet.builder();
        if (this.databaseCapabilities.supportsIdentityColumns()) {
            mappings.add((Object)new ClassPathResource("com/atlassian/confluence/journal/JournalEntry-identity.hbm.xml"));
        } else if (this.databaseCapabilities.supportsSequences() && this.databaseCapabilities.isOracle()) {
            mappings.add((Object)new ClassPathResource("com/atlassian/confluence/journal/JournalEntry-oracle.hbm.xml"));
        } else if (this.databaseCapabilities.supportsSequences()) {
            mappings.add((Object)new ClassPathResource("com/atlassian/confluence/journal/JournalEntry-sequence.hbm.xml"));
        } else {
            throw new IllegalStateException("Cannot determine DB type");
        }
        mappings.add((Object)new ClassPathResource("com/atlassian/confluence/journal/JournalEntry-common.hbm.xml"));
        mappings.add((Object)this.getDenormalisedSpaceChangeLogMapping());
        mappings.add((Object)this.getDenormalisedContentChangeLogMapping());
        return mappings.build();
    }

    private Resource getDenormalisedSpaceChangeLogMapping() {
        return this.databaseCapabilities.isOracle() ? new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedSpaceChangeLogSequence.hbm.xml") : new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedSpaceChangeLogIdentity.hbm.xml");
    }

    private Resource getDenormalisedContentChangeLogMapping() {
        return this.databaseCapabilities.isOracle() ? new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedContentChangeLogSequence.hbm.xml") : new ClassPathResource("com/atlassian/confluence/security/denormalisedpermissions/DenormalisedContentChangeLogIdentity.hbm.xml");
    }
}

