/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.core.persistence.hibernate.schema;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.core.persistence.hibernate.HibernateDatabaseCapabilities;
import com.atlassian.confluence.impl.hibernate.DataAccessUtils;
import com.atlassian.confluence.internal.upgrade.ColumnTypeChecker;
import com.atlassian.confluence.internal.upgrade.index.IndexChecker;
import com.atlassian.confluence.upgrade.ddl.AddStringVirtualColumnForNullableColumnCommand;
import com.atlassian.confluence.upgrade.ddl.AlterTableExecutor;
import com.atlassian.confluence.upgrade.ddl.CreateIndexCommand;
import com.atlassian.confluence.upgrade.ddl.DdlExecutor;
import com.atlassian.confluence.upgrade.ddl.DropColumnCommand;
import com.atlassian.confluence.upgrade.ddl.HibernateAlterTableExecutor;
import com.atlassian.confluence.util.MemoizingComponentReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowCountCallbackHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class LabelUniqueIndexHelper {
    private static final Logger log = LoggerFactory.getLogger(LabelUniqueIndexHelper.class);
    public static final String CQ_TOPIC_METADATA_PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-questions:topic-metadata";
    public static final String CQ_QUESTION_PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-questions:question";
    public static final String OWNER_NOT_NULL_COLUM_TYPE = "confluence.upgrade.label.owner.not.null.column.type";
    public static final String ID_COLUMN = "ID";
    public static final String USERNAME_COLUMN = "USERNAME";
    public static final String NOTIFICATION_ID_COLUMN = "NOTIFICATIONID";
    public static final String CONTENT_ID_COLUMN = "CONTENTID";
    public static final String LABEL_ID_COLUMN = "LABELID";
    public static final String LABEL_NAME_COLUMN = "NAME";
    public static final String LABEL_OWNER_COLUMN = "OWNER";
    public static final String LABEL_NAMESPACE_COLUMN = "NAMESPACE";
    public static final String LABEL_TABLE_NAME = "LABEL";
    private static final String OWNER_PLACEHOLDER = "";
    public static final String OWNER_VIRTUAL_COLUMN = "OWNER_NOT_NULL";
    public static final List<String> UNIQUE_INDEX_COLUMNS = List.of("NAME", "OWNER_NOT_NULL", "NAMESPACE");
    public static final String UNIQUE_INDEX_NAME = "IDX_UNIQUE_LABEL_NAME_OWNER_NOT_NULL_NAMESPACE";
    public static final CreateIndexCommand ADD_UNIQUE_INDEX = new CreateIndexCommand("IDX_UNIQUE_LABEL_NAME_OWNER_NOT_NULL_NAMESPACE", "LABEL", true, UNIQUE_INDEX_COLUMNS.toArray(new String[0]));
    public static final String SQL_SELECT_DUPLICATE_LABELS = "SELECT l1.* FROM LABEL l1, LABEL l2 WHERE l1.LABELID <> l2.LABELID    AND (l1.NAME = l2.NAME OR (l1.NAME IS NULL AND l2.NAME IS NULL))    AND (l1.OWNER = l2.OWNER OR (l1.OWNER IS NULL AND l2.OWNER IS NULL))    AND (l1.NAMESPACE = l2.NAMESPACE OR (l1.NAMESPACE IS NULL AND l2.NAMESPACE IS NULL)) ORDER BY l1.NAME, l1.OWNER, l1.NAMESPACE, l1.LABELID ASC";
    public static final String SQL_COUNT_CQ_TOPIC_METADATA = String.format("SELECT COUNT(*) FROM CONTENT WHERE PLUGINKEY = '%s'", "com.atlassian.confluence.plugins.confluence-questions:topic-metadata");
    private final SessionFactory sessionFactory;
    private final DdlExecutor ddlExecutor;
    private final PlatformTransactionManager transactionManager;
    private final HibernateDatabaseCapabilities databaseCapabilities;
    private final Supplier<CustomContentManager> customContentManagerSupplier = MemoizingComponentReference.containerComponent("customContentManager");

    public LabelUniqueIndexHelper(SessionFactory sessionFactory, DdlExecutor ddlExecutor, HibernateDatabaseCapabilities databaseCapabilities, PlatformTransactionManager transactionManager) {
        this.sessionFactory = sessionFactory;
        this.ddlExecutor = ddlExecutor;
        this.databaseCapabilities = databaseCapabilities;
        this.transactionManager = transactionManager;
    }

    public void cleanUpDuplicatedLabels() {
        if (this.indexExists()) {
            return;
        }
        this.doInTransaction(() -> {
            Session session = this.sessionFactory.getCurrentSession();
            JdbcTemplate template = DataAccessUtils.getJdbcTemplate(session);
            log.info("Looking for duplicate label records.");
            AtomicInteger duplicateRows = new AtomicInteger(0);
            LabelRecordRowHolder lastUniqueRow = new LabelRecordRowHolder();
            template.query(SQL_SELECT_DUPLICATE_LABELS, (RowCallbackHandler)this.getLabelRowCountCallbackHandler(template, duplicateRows, lastUniqueRow, this.isCQTopicExists()));
            if (duplicateRows.get() > 0) {
                log.info("Removed {} duplicated label records.", (Object)duplicateRows.get());
            }
        });
    }

    public void createVirtualColumnAndUniqueIndex() {
        if (this.indexExists()) {
            return;
        }
        try {
            this.doInTransaction(() -> {
                this.dropVirtualColumn();
                log.info("Starting adding of virtual column to {} table.", (Object)LABEL_TABLE_NAME);
                this.alterTableExecutor().alterTable(LABEL_TABLE_NAME, List.of(this.getAddVirtualColumnCommand()));
                log.info("Finished adding of virtual column to {} table.", (Object)LABEL_TABLE_NAME);
                log.info("Starting adding of unique index to {} table.", (Object)LABEL_TABLE_NAME);
                this.ddlExecutor.executeDdl(List.of(ADD_UNIQUE_INDEX));
                log.info("Finished adding of unique index to {} table.", (Object)LABEL_TABLE_NAME);
            });
        }
        catch (Throwable e) {
            log.error("LabelUniqueIndexUpgradeTask: Fails to add unique index {} for {} table due to below error. Confluence upgrade will continue as this upgrade task is optional. If you want to remove duplicate labels and add unique index, you can rerun the labelUniqueConstraintUpgradeTask after fixing the below causes", (Object)UNIQUE_INDEX_NAME, (Object)LABEL_TABLE_NAME);
            log.error(e.getMessage(), e);
        }
    }

    public void dropVirtualColumnAndUniqueIndex() {
        if (!this.indexExists()) {
            return;
        }
        log.info("Starting dropping of unique index and virtual column from {} table.", (Object)LABEL_TABLE_NAME);
        this.dropUniqueIndex();
        this.dropVirtualColumn();
        log.info("Finished dropping of unique index and virtual column from {} table.", (Object)LABEL_TABLE_NAME);
    }

    private void dropVirtualColumn() {
        try {
            this.doInTransaction(() -> this.alterTableExecutor().alterTable(LABEL_TABLE_NAME, List.of(new DropColumnCommand(OWNER_VIRTUAL_COLUMN))));
        }
        catch (Throwable e) {
            log.info("Ignoring non-existence of {} column on {}", (Object)OWNER_VIRTUAL_COLUMN, (Object)LABEL_TABLE_NAME);
        }
    }

    private void dropUniqueIndex() {
        try {
            this.doInTransaction(() -> this.ddlExecutor.executeDdl(List.of(this.ddlExecutor.createDropIndexCommand(UNIQUE_INDEX_NAME, LABEL_TABLE_NAME))));
        }
        catch (Throwable e) {
            log.info("Ignoring non-existence of {} index on {}", (Object)UNIQUE_INDEX_NAME, (Object)LABEL_TABLE_NAME);
        }
    }

    public boolean indexExists() {
        return (Boolean)this.doInTransaction(status -> this.indexChecker().indexExists(UNIQUE_INDEX_NAME, LABEL_TABLE_NAME));
    }

    private IndexChecker indexChecker() {
        return new IndexChecker(this.databaseCapabilities, DataAccessUtils.getJdbcTemplate(this.sessionFactory.getCurrentSession()));
    }

    private ColumnTypeChecker columnTypeChecker() {
        return new ColumnTypeChecker(this.databaseCapabilities, DataAccessUtils.getJdbcTemplate(this.sessionFactory.getCurrentSession()));
    }

    private String getOwnerColumnType() {
        try {
            return (String)this.doInTransaction(status -> this.columnTypeChecker().getColumnType(LABEL_OWNER_COLUMN, LABEL_TABLE_NAME));
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private RowCountCallbackHandler getLabelRowCountCallbackHandler(final JdbcTemplate template, final AtomicInteger duplicateRows, final LabelRecordRowHolder lastUniqueRow, final boolean isCQTopicExists) {
        return new RowCountCallbackHandler(){

            protected void processRow(ResultSet rs, int rowNum) throws SQLException {
                LabelRecordRowHolder currentRow = new LabelRecordRowHolder();
                currentRow.assignFrom(rs);
                if (LabelUniqueIndexHelper.this.isLabelDuplicated(lastUniqueRow, currentRow)) {
                    duplicateRows.incrementAndGet();
                    long duplicatedLabelId = currentRow.getId();
                    long uniqueLabelId = lastUniqueRow.getId();
                    log.info("Start processing duplicated label record with ID: {}. Merging with label record with ID: {}.", (Object)duplicatedLabelId, (Object)uniqueLabelId);
                    if (isCQTopicExists) {
                        LabelUniqueIndexHelper.this.updateTopicWatchesWithUniqueLabelId(template, duplicatedLabelId, uniqueLabelId);
                        LabelUniqueIndexHelper.this.updateContentLabelsForDifferentLabelSources(template, duplicatedLabelId, uniqueLabelId);
                    } else {
                        LabelUniqueIndexHelper.this.updateContentLabelsWithUniqueLabelId(template, duplicatedLabelId, uniqueLabelId);
                    }
                    LabelUniqueIndexHelper.this.deleteDuplicatedLabel(template, currentRow);
                    log.info("Finish processing duplicated label record with ID: {}", (Object)duplicatedLabelId);
                } else {
                    lastUniqueRow.assignFrom(currentRow);
                }
            }
        };
    }

    private RowCountCallbackHandler getContentLabelRowCountCallbackHandler(final JdbcTemplate template, final long uniqueLabelId) {
        return new RowCountCallbackHandler(){

            protected void processRow(ResultSet rs, int rowNum) throws SQLException {
                long contentLabelId = rs.getLong(LabelUniqueIndexHelper.ID_COLUMN);
                long contentId = rs.getLong(LabelUniqueIndexHelper.CONTENT_ID_COLUMN);
                CustomContentEntityObject content = LabelUniqueIndexHelper.this.customContentManager().getById(contentId);
                if (content != null && LabelUniqueIndexHelper.CQ_TOPIC_METADATA_PLUGIN_KEY.equals(content.getPluginModuleKey())) {
                    LabelUniqueIndexHelper.this.customContentManager().removeContentEntity(content);
                } else {
                    LabelUniqueIndexHelper.this.updateContentLabelWithUniqueLabelId(template, contentLabelId, uniqueLabelId);
                }
            }
        };
    }

    private void deleteDuplicatedLabel(JdbcTemplate template, LabelRecordRowHolder duplicatedRow) {
        template.update(String.format("DELETE FROM LABEL WHERE LABELID = %d", duplicatedRow.id));
        log.info("Deleted duplicated label record with ID: {}.", (Object)duplicatedRow.id);
    }

    private void updateContentLabelsForDifferentLabelSources(JdbcTemplate template, long duplicatedLabelId, long uniqueLabelId) {
        RowCountCallbackHandler callbackHandler = this.getContentLabelRowCountCallbackHandler(template, uniqueLabelId);
        template.query("SELECT * FROM CONTENT_LABEL WHERE LABELID = ?", (RowCallbackHandler)callbackHandler, new Object[]{duplicatedLabelId});
    }

    private void updateContentLabelWithUniqueLabelId(JdbcTemplate template, long contentLabelId, long uniqueLabelId) {
        template.update(String.format("UPDATE CONTENT_LABEL SET LABELID = %d WHERE ID = %d", uniqueLabelId, contentLabelId));
        log.info("Updated CONTENT_LABEL record with ID: {} to link label {}.", (Object)contentLabelId, (Object)uniqueLabelId);
    }

    private void updateContentLabelsWithUniqueLabelId(JdbcTemplate template, long duplicatedLabelId, long uniqueLabelId) {
        template.update(String.format("UPDATE CONTENT_LABEL SET LABELID = %d WHERE LABELID = %d", uniqueLabelId, duplicatedLabelId));
        log.info("Updated CONTENT_LABEL records to link from label {} to label {}.", (Object)duplicatedLabelId, (Object)uniqueLabelId);
    }

    private void updateTopicWatchesWithUniqueLabelId(JdbcTemplate template, long duplicatedLabelId, long uniqueLabelId) {
        RowCountCallbackHandler callbackHandler = this.getTopicWatchRowCountCallbackHandler(template, uniqueLabelId);
        template.query("SELECT * FROM NOTIFICATIONS WHERE LABELID = ?", (RowCallbackHandler)callbackHandler, new Object[]{duplicatedLabelId});
    }

    private RowCountCallbackHandler getTopicWatchRowCountCallbackHandler(final JdbcTemplate template, final long uniqueLabelId) {
        return new RowCountCallbackHandler(){

            protected void processRow(ResultSet rs, int rowNum) throws SQLException {
                long notificationID = rs.getLong(LabelUniqueIndexHelper.NOTIFICATION_ID_COLUMN);
                String username = rs.getString(LabelUniqueIndexHelper.USERNAME_COLUMN);
                if (LabelUniqueIndexHelper.this.isTopicWatchExists(uniqueLabelId, username)) {
                    template.update(String.format("DELETE FROM NOTIFICATIONS WHERE NOTIFICATIONID = %d", notificationID));
                    log.info("Deleted duplicated TopicWatch record with ID: {}.", (Object)notificationID);
                } else {
                    template.update(String.format("UPDATE NOTIFICATIONS SET LABELID = %d WHERE NOTIFICATIONID = %d", uniqueLabelId, notificationID));
                    log.info("Updated TopicWatch record with ID: {} to link topic {}.", (Object)notificationID, (Object)uniqueLabelId);
                }
            }
        };
    }

    private boolean isTopicWatchExists(long labelId, String username) {
        return (Boolean)this.doInTransaction(status -> {
            String query = "SELECT COUNT(*) FROM NOTIFICATIONS WHERE LABELID = ? AND USERNAME = ?";
            Long count = (Long)DataAccessUtils.getJdbcTemplate(this.sessionFactory.getCurrentSession()).queryForObject(query, Long.class, new Object[]{labelId, username});
            return count != null && count > 0L;
        });
    }

    private boolean isCQTopicExists() {
        return (Boolean)this.doInTransaction(status -> {
            Long count = (Long)DataAccessUtils.getJdbcTemplate(this.sessionFactory.getCurrentSession()).queryForObject(SQL_COUNT_CQ_TOPIC_METADATA, Long.class);
            return count != null && count > 0L;
        });
    }

    private boolean isLabelDuplicated(LabelRecordRowHolder thisRow, LabelRecordRowHolder thatRow) {
        if (thisRow == null || thatRow == null) {
            return false;
        }
        return ObjectUtils.notEqual((Object)thisRow.getId(), (Object)thatRow.getId()) && Objects.equals(thisRow.getName(), thatRow.getName()) && Objects.equals(thisRow.getOwner(), thatRow.getOwner()) && Objects.equals(thisRow.getNamespace(), thatRow.getNamespace());
    }

    private AlterTableExecutor alterTableExecutor() {
        return new HibernateAlterTableExecutor(this.databaseCapabilities, this.ddlExecutor);
    }

    private CustomContentManager customContentManager() {
        return this.customContentManagerSupplier.get();
    }

    private <T> T doInTransaction(TransactionCallback<T> callback) {
        return (T)new TransactionTemplate(this.transactionManager, (TransactionDefinition)new DefaultTransactionAttribute(3)).execute(callback);
    }

    private void doInTransaction(Runnable runnable) {
        this.doInTransaction(status -> {
            runnable.run();
            return null;
        });
    }

    private AddStringVirtualColumnForNullableColumnCommand getAddVirtualColumnCommand() {
        String virtualColumnType = Optional.ofNullable(this.getOwnerNotNullColumnType()).orElse(this.getOwnerColumnType());
        if (StringUtils.isBlank((CharSequence)virtualColumnType)) {
            log.info("Can not retrieve Label table OWNER column type from database, will fallback to use default column type.");
        } else {
            log.info("LABEL table OWNER column type is: {}, will create virtual column with the same type.", (Object)virtualColumnType);
        }
        return new AddStringVirtualColumnForNullableColumnCommand(OWNER_VIRTUAL_COLUMN, LABEL_OWNER_COLUMN, virtualColumnType, OWNER_PLACEHOLDER);
    }

    private String getOwnerNotNullColumnType() {
        return System.getProperty(OWNER_NOT_NULL_COLUM_TYPE, null);
    }

    private static class LabelRecordRowHolder {
        private long id;
        private String name;
        private String owner;
        private String namespace;

        private LabelRecordRowHolder() {
        }

        public void assignFrom(ResultSet rs) throws SQLException {
            this.id = rs.getLong(LabelUniqueIndexHelper.LABEL_ID_COLUMN);
            this.name = rs.getString(LabelUniqueIndexHelper.LABEL_NAME_COLUMN);
            this.owner = rs.getString(LabelUniqueIndexHelper.LABEL_OWNER_COLUMN);
            this.namespace = rs.getString(LabelUniqueIndexHelper.LABEL_NAMESPACE_COLUMN);
        }

        public void assignFrom(LabelRecordRowHolder that) {
            this.id = that.id;
            this.name = that.name;
            this.owner = that.owner;
            this.namespace = that.namespace;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

