/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.event;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.event.api.EventListenerRegistrar;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.core.annotation.MergedAnnotations;

@ParametersAreNonnullByDefault
final class EventListenersRegistrar
implements DestructionAwareBeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(EventListenersRegistrar.class);
    private final EventListenerRegistrar eventListenerRegistrar;
    private final Set<String> candidateBeanNames = Collections.newSetFromMap(new ConcurrentHashMap());

    EventListenersRegistrar(EventListenerRegistrar eventListenerRegistrar) {
        this.eventListenerRegistrar = eventListenerRegistrar;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (EventListenersRegistrar.isCandidate(bean)) {
            this.candidateBeanNames.add(beanName);
            log.debug("Registering bean [{}] with EventListenerRegistrar", (Object)beanName);
            this.eventListenerRegistrar.register(bean);
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.candidateBeanNames.contains(beanName)) {
            this.eventListenerRegistrar.unregister(bean);
        }
    }

    private static boolean isCandidate(Object bean) {
        return MergedAnnotations.from(bean.getClass(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.DIRECT).isPresent(RegisterEventListeners.class);
    }
}

