/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.event;

import com.atlassian.confluence.event.CpuBasedThreadPoolConfiguration;
import com.atlassian.confluence.event.MonitorableCallerRunsPolicy;
import com.atlassian.confluence.impl.event.DurationChecker;
import com.atlassian.event.spi.EventExecutorFactory;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.checkerframework.checker.nullness.qual.NonNull;

final class ThreadPoolEventExecutorFactory
implements EventExecutorFactory {
    private final CpuBasedThreadPoolConfiguration configuration = new CpuBasedThreadPoolConfiguration();
    private final ResettableLazyReference<ExecutorService> executorRef = Lazy.resettable(() -> new ThreadPoolExecutor(this.configuration.getCorePoolSize(), this.configuration.getMaximumPoolSize(), this.configuration.getKeepAliveTime(), this.configuration.getTimeUnit(), new LinkedBlockingQueue<Runnable>(this.configuration.getQueueSize()), threadFactory, new MonitorableCallerRunsPolicy(new DurationChecker(60))));

    public ThreadPoolEventExecutorFactory(ThreadFactory threadFactory) {
    }

    @PreDestroy
    void shutdown() {
        if (this.executorRef.isInitialized()) {
            ((ExecutorService)this.executorRef.get()).shutdown();
            this.executorRef.reset();
        }
    }

    public @NonNull ExecutorService getExecutor() {
        return (ExecutorService)this.executorRef.get();
    }
}

