/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.feature;

import com.atlassian.confluence.impl.feature.SiteDarkFeaturesDao;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PluginSettingsSiteDarkFeaturesDao
implements SiteDarkFeaturesDao {
    static final String SITE_DARKFEATURE_BANDANA_KEY = "confluence.darkfeature";
    private final PluginSettings globalSettings;

    public PluginSettingsSiteDarkFeaturesDao(PluginSettingsFactory pluginSettingsFactory) {
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @Override
    public Set<String> getSiteEnabledFeatures() {
        String features = (String)this.globalSettings.get(SITE_DARKFEATURE_BANDANA_KEY);
        return PluginSettingsSiteDarkFeaturesDao.deserialize(features);
    }

    @Override
    public boolean enableSiteFeature(String featureKey) {
        Set<String> enabledFeatures = this.getSiteEnabledFeatures();
        if (enabledFeatures.contains(featureKey)) {
            return false;
        }
        enabledFeatures.add(featureKey);
        this.updateSiteEnabledDarkFeatures(enabledFeatures);
        return true;
    }

    @Override
    public boolean disableSiteFeature(String featureKey) {
        Set<String> enabledFeatures = this.getSiteEnabledFeatures();
        if (!enabledFeatures.contains(featureKey)) {
            return false;
        }
        enabledFeatures.remove(featureKey);
        this.updateSiteEnabledDarkFeatures(enabledFeatures);
        return true;
    }

    private void updateSiteEnabledDarkFeatures(Set<String> enabledFeatures) {
        this.globalSettings.put(SITE_DARKFEATURE_BANDANA_KEY, (Object)PluginSettingsSiteDarkFeaturesDao.serialize(enabledFeatures));
    }

    private static String serialize(Set<String> features) {
        return StringUtils.join(features, (String)",");
    }

    private static Set<String> deserialize(String features) {
        if (StringUtils.isBlank((CharSequence)features)) {
            return new HashSet<String>();
        }
        return Sets.newHashSet((Object[])features.split(","));
    }
}

