/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.health;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.core.HeartbeatManager;
import com.atlassian.confluence.impl.health.CasUtils;
import com.atlassian.confluence.internal.user.DeferredLookupUser;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import io.atlassian.fugue.Either;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCacheHeartbeatManager
implements HeartbeatManager {
    private static final Logger log = LoggerFactory.getLogger(SharedCacheHeartbeatManager.class);
    private static final String ACTIVITIES_CACHE_NAME = "com.atlassian.confluence.core.DefaultHeartbeatManager.activities";
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private final ConfluenceUserResolver userAccessor;
    private final DataStore<CacheData> dataStore;

    SharedCacheHeartbeatManager(DataStore<CacheData> dataStore, ConfluenceUserResolver userResolver) {
        this.userAccessor = userResolver;
        this.dataStore = dataStore;
    }

    @Override
    public long getHeartbeatInterval() {
        return TIMEOUT.toMillis();
    }

    @Override
    public List<User> getUsersForActivity(String activityKey) {
        return this.findUserKeysForActivity(activityKey).map(DeferredLookupUser::new).collect(Collectors.toList());
    }

    @Override
    public Set<UserKey> getUserKeysForActivity(HeartbeatManager.ActivityKey activity) {
        return this.findUserKeysForActivity(activity.str()).collect(Collectors.toSet());
    }

    Stream<UserKey> findUserKeysForActivity(String activityKey) {
        Either<Throwable, CacheData> either = this.dataStore.atomicReplace(activityKey, this::cleanTimedOutActivities, CacheData::new, TIMEOUT);
        CacheData cacheData = (CacheData)either.getOrThrow(() -> new RuntimeException("Unable to fetch users for activity: " + activityKey, (Throwable)either.left().get()));
        return cacheData.getActivities().stream().map(activity -> activity.userKey);
    }

    @Override
    public void startActivity(String activityKey, String username) {
        this.startActivity(activityKey, (User)this.userAccessor.getUserByName(username));
    }

    @Override
    public void startActivity(String activityKey, User user) {
        if (user == null) {
            return;
        }
        Either<Throwable, CacheData> either = this.dataStore.atomicReplace(activityKey, cacheData -> {
            CacheData result = new CacheData(cacheData.getActivities());
            Activity activity = new Activity(activityKey, FindUserHelper.getUser(user).getKey());
            result.getActivities().remove(activity);
            result.getActivities().add(activity);
            return result;
        }, () -> new CacheData(Collections.singleton(new Activity(activityKey, FindUserHelper.getUser(user).getKey()))), TIMEOUT);
        either.bimap(exception -> {
            log.error("Unable to start heartbeat activity", exception);
            return exception;
        }, v -> v);
    }

    @Override
    public void stopActivity(String activityKey, String username) {
        this.stopActivity(activityKey, (User)this.userAccessor.getUserByName(username));
    }

    @Override
    public void stopActivity(String activityKey, User user) {
        if (user == null) {
            return;
        }
        Either<Throwable, CacheData> either = this.dataStore.atomicReplace(activityKey, cacheData -> {
            CacheData result = new CacheData(cacheData.getActivities());
            Activity activity = new Activity(activityKey, FindUserHelper.getUser(user).getKey());
            result.getActivities().remove(activity);
            return result;
        }, CacheData::new, TIMEOUT);
        either.bimap(exception -> {
            log.error("Unable to stop heartbeat activity", exception);
            return exception;
        }, v -> v);
    }

    private CacheData cleanTimedOutActivities(CacheData cacheData) {
        return new CacheData(cacheData.getActivities().stream().filter(activity -> Instant.now().toEpochMilli() - activity.timestamp.toEpochMilli() <= 2L * TIMEOUT.toMillis()).collect(Collectors.toSet()));
    }

    public static interface DataStore<V> {
        public Either<Throwable, V> atomicReplace(String var1, Function<V, V> var2, Supplier<V> var3, Duration var4);

        public static <V> DataStore<V> create(CacheFactory cacheFactory) {
            return DataStore.create(cacheFactory.getCache(SharedCacheHeartbeatManager.ACTIVITIES_CACHE_NAME, null, new CacheSettingsBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build()));
        }

        public static <V> DataStore<V> create(Cache<String, V> cache) {
            return (key, updater, defaultSupplier, maxDuration) -> CasUtils.internalAtomicLoop((Duration)maxDuration, () -> DataStore.lambda$create$0(cache, key, updater, (Supplier)defaultSupplier));
        }

        private static /* synthetic */ Optional lambda$create$0(Cache cache, String key, Function updater, Supplier defaultSupplier) {
            Object existingValue = cache.get((Object)key);
            if (existingValue != null) {
                Object newValue = updater.apply(existingValue);
                boolean replaced = cache.replace((Object)key, existingValue, newValue);
                if (replaced) {
                    return Optional.of(Either.right(newValue));
                }
                return Optional.empty();
            }
            Object newValue = defaultSupplier.get();
            Object oldValue = cache.putIfAbsent((Object)key, newValue);
            if (oldValue != null) {
                return Optional.empty();
            }
            return Optional.of(Either.right(newValue));
        }
    }

    static class CacheData
    implements Serializable {
        private static final long serialVersionUID = 127177732888L;
        private final TreeSet<Activity> activities;

        private CacheData() {
            this.activities = new TreeSet();
        }

        private CacheData(Set<Activity> activities) {
            this.activities = new TreeSet(Objects.requireNonNull(activities));
        }

        public Set<Activity> getActivities() {
            return this.activities;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.activities.equals(((CacheData)o).getActivities());
        }

        public int hashCode() {
            return this.activities.hashCode();
        }
    }

    private static class Activity
    implements Serializable,
    Comparable<Activity> {
        private final Instant timestamp;
        private final UserKey userKey;
        private final String activityKey;

        public Activity(String activityKey, UserKey user) {
            this(Objects.requireNonNull(activityKey), Objects.requireNonNull(user), Instant.now());
        }

        public Activity(String activityKey, UserKey userKey, Instant timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp);
            this.userKey = Objects.requireNonNull(userKey);
            this.activityKey = Objects.requireNonNull(activityKey);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Activity activity = (Activity)o;
            return Objects.equals(this.userKey, activity.userKey) && Objects.equals(this.activityKey, activity.activityKey);
        }

        public int hashCode() {
            return Objects.hash(this.userKey, this.activityKey);
        }

        @Override
        public int compareTo(Activity o) {
            int byActivity = this.activityKey.compareTo(o.activityKey);
            return byActivity != 0 ? byActivity : this.userKey.toString().compareTo(o.userKey.toString());
        }
    }
}

