/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.health.checks;

import com.atlassian.confluence.impl.health.HealthCheckTemplate;
import com.atlassian.confluence.impl.health.checks.rules.HealthCheckRule;
import com.atlassian.confluence.internal.health.HealthCheckResult;
import com.atlassian.confluence.internal.health.LifecyclePhase;
import com.google.common.base.Stopwatch;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSetupHealthCheck
extends HealthCheckTemplate {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSetupHealthCheck.class);
    private final Collection<HealthCheckRule> databaseSetupRules;

    protected DatabaseSetupHealthCheck(HealthCheckRule ... databaseSetupRules) {
        super(Collections.emptyList());
        this.databaseSetupRules = Arrays.asList(databaseSetupRules);
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return Collections.singleton(LifecyclePhase.BOOTSTRAP_END);
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        return this.databaseSetupRules.stream().flatMap(this::validate).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<HealthCheckResult> validate(HealthCheckRule rule) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Stream<HealthCheckResult> stream = rule.validate(this).stream();
            return stream;
        }
        finally {
            log.debug("Executed {} in {}", (Object)rule, (Object)stopwatch.elapsed().truncatedTo(ChronoUnit.MILLIS));
        }
    }
}

