/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.hibernate;

import com.atlassian.confluence.persistence.JpaQueryFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.function.Supplier;
import org.hibernate.SessionFactory;

public final class EntityManagerQueryFactory
implements JpaQueryFactory {
    private final Supplier<EntityManager> entityManagerRef;

    public EntityManagerQueryFactory(EntityManager entityManager) {
        this(() -> entityManager);
    }

    public EntityManagerQueryFactory(SessionFactory sessionFactory) {
        this(() -> ((SessionFactory)sessionFactory).getCurrentSession());
    }

    private EntityManagerQueryFactory(Supplier<EntityManager> entityManagerRef) {
        this.entityManagerRef = entityManagerRef;
    }

    @Override
    public Query createQuery(String qlString) {
        return this.entityManagerRef.get().createQuery(qlString);
    }

    @Override
    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return this.entityManagerRef.get().createQuery(qlString, resultClass);
    }

    @Override
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return this.entityManagerRef.get().createQuery(criteriaQuery);
    }

    @Override
    public Query createNativeQuery(String sqlString) {
        return this.entityManagerRef.get().createNativeQuery(sqlString);
    }

    @Override
    public <T> Query createNativeQuery(String sqlString, Class<T> resultClass) {
        return this.entityManagerRef.get().createNativeQuery(sqlString, resultClass);
    }
}

