/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.hibernate;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.LazyComponentReference;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Supplier;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@UnrestrictedAccess
public final class OpenSessionInViewFilter
extends HttpFilter {
    private final Supplier<SessionFactory> sessionFactoryRef;
    private final Supplier<HibernateConfig> hibernateConfigRef;

    public OpenSessionInViewFilter() {
        this((Supplier<SessionFactory>)new LazyComponentReference("sessionFactory"), (Supplier<HibernateConfig>)new LazyComponentReference("hibernateConfig"));
    }

    OpenSessionInViewFilter(Supplier<SessionFactory> sessionFactoryRef, Supplier<HibernateConfig> hibernateConfigRef) {
        this.sessionFactoryRef = sessionFactoryRef;
        this.hibernateConfigRef = hibernateConfigRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean useExistingSession;
        if (this.isConfluenceStillStarting()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        SessionFactory sessionFactory = this.sessionFactoryRef.get();
        if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
            useExistingSession = true;
        } else {
            useExistingSession = false;
            Session session = this.openSession(sessionFactory);
            SessionHolder sessionHolder = new SessionHolder(session);
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)sessionHolder);
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!useExistingSession) {
                SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
                SessionFactoryUtils.closeSession((Session)sessionHolder.getSession());
            }
        }
    }

    private boolean isConfluenceStillStarting() {
        return !ContainerManager.isContainerSetup() || !this.hibernateConfigRef.get().isHibernateSetup();
    }

    private Session openSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = sessionFactory.openSession();
        session.setHibernateFlushMode(FlushMode.MANUAL);
        return session;
    }
}

